/*

		Preloader scene
		- preloads all main assets.
		- each scene will (pre)load its own assets on top of that (if needed)

*/ class Preloader extends Wrapper {
    constructor(){
        super("Preloader");
    }
    preload() {
        this.scale.fullscreenTarget = document.getElementById("gameDiv");
        var parent = this;
        fetch("./assets/dialog/dialog.json").then(function(response) {
            if (response.status !== 200) {
                log("Looks like there was a problem. Status Code: " + response.status);
                return;
            }
            response.json().then(function(data) {
                log(data);
                fullDialog = data;
            });
        }).catch(function(err) {
            log("Fetch Error :-S", err);
        });
        fetch("./assets/dialog/hints.json").then(function(response) {
            if (response.status !== 200) {
                log("Looks like there was a problem. Status Code: " + response.status);
                return;
            }
            response.json().then(function(data) {
                log(data);
                allHints = data;
            });
        }).catch(function(err) {
            log("Fetch Error :-S", err);
        });
        // Add loading screen bars
        preloaderBar.create(this, {
            posX: 0,
            posY: 900,
            callback: ()=>{
                parent.complete();
            }
        });
        // preload MAIN assets
        // UI
        this.load.image("HintPopup", "assets/img/UI/HintPopup.png");
        this.load.image("HintSalary", "assets/img/UI/HintSalary.png");
        this.load.image("HomeBtn", "assets/img/UI/home.png");
        this.load.image("BackBtn", "assets/img/UI/UIBackBtn.png");
        this.load.image("MenuBar", "assets/img/SD/menuBar.png");
        this.load.image("BuySkinBtn", "assets/img/SD/BuySkinBtn.png");
        this.load.image("crystalicon", "assets/img/SD/crystalicon.png");
        this.load.image("euroIcon", "assets/img/SD/euroIcon.png");
        this.load.image("minusOneSec", "assets/img/SD/minusOneSec.png");
        this.load.image("button_small", "assets/img/SD/button_small.png");
        this.load.image("button_large", "assets/img/SD/button_large.png");
        this.load.image("gameOverBG", "assets/img/UI/GameOverBG.png");
        this.load.image("lootboxBG", "assets/img/UI/LootboxBG.png");
        this.load.image("lotteryBG", "assets/img/UI/LotterieBG.png");
        this.load.image("SoundBtn_on", "assets/img/UI/soundBtnOn.png");
        this.load.image("SoundBtn_off", "assets/img/UI/soundBtnOff.png");
        this.load.image("Logo", "assets/img/Logo.png");
        ///Lootboxes
        this.load.image("1_lootBox", "assets/img/SD/1_lootboxes.png");
        this.load.image("2_lootBox", "assets/img/SD/2_lootboxes.png");
        this.load.image("3_lootBox", "assets/img/SD/3_lootboxes.png");
        this.load.image("medPile_lootBox", "assets/img/SD/medpile_lootbox.png");
        this.load.image("bigPile_lootBox", "assets/img/SD/bigpile_lootbox.png");
        this.load.image("glow", "assets/img/SD/glow.png");
        this.load.image("legendarySkin", "assets/img/SD/legendary_Skin.png");
        this.load.image("CrystalGet", "assets/img/SD/crystalGet.png");
        //Junk items
        //TODO: Different Junk items?
        this.load.image("Junk1", "assets/Coin/Junk1.png");
        this.load.image("Junk2", "assets/Coin/Junk2.png");
        this.load.image("Junk3", "assets/Coin/Junk3.png");
        this.load.image("Junk4", "assets/Coin/Junk4.png");
        // Slot Machine
        this.load.image("bars", "assets/img/strip.png");
        //TIMER
        this.load.image("black-layer", "assets/img/UI/black-layer.png");
        this.load.image("red-layer", "assets/img/UI/red-layer.png");
        this.load.image("timerBg", "assets/img/UI/TimerBg.png");
        // Audio
        this.load.audio("bgm2", "assets/sounds/Chemical.mp3");
        //SFX
        this.load.audio("StartButton", "assets/sounds/StartButton.mp3");
        this.load.audio("ButtonClick", "assets/sounds/ButtonClick.mp3");
        this.load.audio("ButtonHover", "assets/sounds/ButtonHover.mp3");
        this.load.audio("CloseMenu", "assets/sounds/CloseMenu.mp3");
        this.load.audio("Success", "assets/sounds/Success.mp3");
        this.load.audio("Research", "assets/sounds/Research.mp3");
        this.load.audio("Book", "assets/sounds/Book.mp3");
        this.load.audio("Salary", "assets/sounds/Salary.mp3");
        this.load.audio("Coins", "assets/sounds/Coins.mp3");
        this.load.audio("Salary_Failed", "assets/sounds/Salary_Failed.mp3");
        this.load.audio("Crystal", "assets/sounds/Crystal.mp3");
        this.load.audio("Lottery", "assets/sounds/Lottery.mp3");
        this.load.audio("Timeout", "assets/sounds/Timeout.mp3");
        this.load.audio("Empty_Lootbox", "assets/sounds/Empty_Lootbox.mp3");
        this.load.audio("Lootbox", "assets/sounds/Lootbox.mp3");
        this.load.audio("Error", "assets/sounds/Error.mp3");
        // HTML
        this.load.html("txtInput", "assets/html/input.html");
        // SD images
        this.load.image("sdStart", "assets/img/SD/sdStart.png");
        this.load.image("sdBtn", "assets/img/SD/sdBtn.png");
        // SPRITE SHEETS
        this.load.spritesheet("CoinD", "assets/Coin/MonedaD.png", {
            frameWidth: 16,
            frameHeight: 16
        });
        this.load.spritesheet("CoinP", "assets/Coin/MonedaP.png", {
            frameWidth: 16,
            frameHeight: 16
        });
        this.load.spritesheet("CoinR", "assets/Coin/MonedaR.png", {
            frameWidth: 16,
            frameHeight: 16
        });
        this.load.spritesheet("CrystalG", "assets/Coin/spr_coin_gri.png", {
            frameWidth: 16,
            frameHeight: 16
        });
        // default/prototype image
        this.load.image("missingAsset", "assets/img/MissingAsset.png");
    }
    complete() {
        log("PRELOADER: Asset preload done");
        this.scene.start(gameConfig.startingScene);
        this.scene.launch("Audio");
        this.scene.launch("DialogManager");
        this.scene.launch("Gametimer");
        this.scene.launch("Modal");
        this.scene.bringToTop("Modal");
        this.scene.bringToTop("Gametimer");
        this.scene.bringToTop(gameConfig.uiLayer);
        dialogManager = this.scene.get("DialogManager");
    }
    create() {}
}

//# sourceMappingURL=index.0211a667.js.map
