/*

    Modal scene
    - blocks all inputs

*/ class Modal extends Phaser.Scene {
    constructor(){
        super("Modal");
    }
    init() {
        this.blockZone;
        this.isActive = false;
    }
    preload() {}
    create() {
        this.blockZone = this.add.zone(0, 0, this.game.config.width, this.game.config.height).setOrigin(0).on("pointerdown", function() {
            log("INPUTS BLOCKED!");
        });
    }
    update() {}
    blockInputs(doBlock = true) {
        if (doBlock) {
            this.scene.bringToTop("Modal");
            this.isActive = true;
            this.blockZone.setInteractive({
                useHandCursor: false
            });
        } else {
            this.isActive = false;
            this.blockZone.removeInteractive();
        }
    }
}

//# sourceMappingURL=index.1e2d47f7.js.map
