var LootboxScreen = {
    lootData: null,
    currentScene: null,
    amount: null,
    preload: function() {
        this.audioplayer = this.scene.get("Audio");
    },
    create: function(scene, lootboxes, sData) {
        this.LootboxScreen = scene.add.group();
        lootData = sData;
        currentScene = scene;
        amount = lootboxes;
        this.BGZone = scene.add.zone(0, 0, width, height).setOrigin(0).setInteractive().on("pointerup", function() {});
        this.Bg = scene.add.image(72, 260, "lootboxBG");
        //Show different image based on amount to open
        var boxesShown = "";
        if (amount == 1) boxesShown = "1";
        else if (amount == 2) boxesShown = "2";
        else if (amount == 3) boxesShown = "3";
        else if (amount < 30) {
            boxesShown = "medPile";
            log("boxesShown:" + boxesShown);
        } else if (amount > 29) {
            //Show big pile
            boxesShown = "bigPile";
            log("boxesShown:" + boxesShown);
        }
        this.lootBoxImg = scene.add.image(centerX, centerY - 120, boxesShown + "_lootBox").setScale(0.5).setDepth(900);
        this.btnOpen = scene.add.image(centerX, centerY + 125, "button_small").setInteractive({
            useHandCursor: true
        }).on("pointerover", ()=>{
            scene.audioplayer.playSFX("ButtonHover");
            this.btnOpen.setDisplaySize(this.btnOpen.displayWidth + 5, this.btnOpen.displayHeight + 5);
        }).on("pointerout", ()=>{
            scene.audioplayer.playSFX("ButtonHover");
            this.btnOpen.setDisplaySize(this.btnOpen.displayWidth - 5, this.btnOpen.displayHeight - 5);
        }).on("pointerdown", ()=>{
            this.openLootBox();
            this.btnOpen.visible = false;
            this.openText.visible = false;
        });
        this.openText = scene.add.text(centerX, centerY + 120, "\xd6ffnen", {
            align: "center",
            fontFamily: "Impact",
            color: "Black",
            stroke: "White",
            strokeThickness: 1,
            fontSize: "34px",
            wordWrap: {
                width: 450
            }
        }).setShadow(0, 4, "rgba(0,0,0,0.25)", 5).setOrigin(0.5);
        this.Bg.setOrigin(0);
        this.LootboxScreen.addMultiple([
            this.BGZone,
            this.Bg,
            this.lootBoxImg,
            this.btnOpen,
            this.openText
        ]);
        return this.LootboxScreen;
    },
    openLootBox () {
        gameData.Lootboxes_Opened += amount;
        log("Lootboxes opened:" + gameData.Lootboxes_Opened);
        //Glow Effect
        this.glowImg = currentScene.add.image(this.lootBoxImg.x, this.lootBoxImg.y, "glow").setScale(1).setDepth(1000).setAlpha(0);
        currentScene.tweens.add({
            targets: this.glowImg,
            alpha: 0.8,
            ease: "Cubic",
            duration: 300
        });
        this.LootboxScreen.add(this.glowImg);
        skinGiven = false;
        var crystalsGiven = 0;
        currentScene.audioplayer.playSFX("Lootbox");
        for(let i = 0; i < amount; i++){
            var lootBoxResult = Math.floor(random() * 1000) + 1;
            log("\nOpening Box number " + i);
            log("lootBoxResult:" + lootBoxResult);
            for(var j = 2; j < Object.keys(lootData.OpenBox).length; j++){
                //Check if skin was given
                if (lootBoxResult <= lootData.OpenBox[1].chance * 10) {
                    skinGiven = true;
                    break;
                }
                //Check if crystals were given
                if (lootBoxResult <= lootData.OpenBox[j].chance * 10) {
                    log("You got " + lootData.OpenBox[j].content + " Crystals!");
                    crystalsGiven += lootData.OpenBox[j].content;
                    break;
                }
            }
        }
        log("Crystals given: " + crystalsGiven);
        //Result visualization
        //Explode out 1 Junk item per box opened
        currentScene.explodeParticles("Junk", this.lootBoxImg.x, this.lootBoxImg.y, amount);
        //Explode crystals if any were given out
        if (crystalsGiven > 0 && !skinGiven) {
            currentScene.explodeParticles("CrystalG", this.lootBoxImg.x, this.lootBoxImg.y, crystalsGiven / 10);
            currentScene.audioplayer.playSFX("Crystal");
            //Display Crystal and text
            this.crystalImg = currentScene.add.sprite(this.lootBoxImg.x - 60, this.lootBoxImg.y, "CrystalGet").setScale(1).setDepth(2000);
            this.crystalsText = currentScene.add.text(this.lootBoxImg.x + 10, this.lootBoxImg.y - 30, "+" + crystalsGiven, {
                fontFamily: "TheSansMono-8-Bold",
                fontSize: "56px",
                stroke: "#000000",
                strokeThickness: 5
            }).setDepth(2000);
            currentScene.tweens.add({
                targets: this.crystalImg,
                y: this.lootBoxImg.y - 200,
                ease: "Power1",
                duration: 1000
            });
            currentScene.tweens.add({
                targets: this.crystalsText,
                y: this.lootBoxImg.y - 230,
                ease: "Power1",
                duration: 1000
            });
            this.LootboxScreen.addMultiple([
                this.crystalImg,
                this.crystalsText
            ]);
        }
        //Show skin if it was won
        if (skinGiven == true) {
            currentScene.audioplayer.playSFX("Success");
            this.legendarySkinImg = currentScene.add.image(this.lootBoxImg.x, this.lootBoxImg.y, "legendarySkin").setScale(0.3).setDepth(2000);
            this.glowImgSkin = currentScene.add.image(this.lootBoxImg.x - 10, this.lootBoxImg.y, "glow").setAlpha(0).setDepth(1900);
            currentScene.tweens.add({
                targets: [
                    this.legendarySkinImg,
                    this.glowImgSkin
                ],
                y: this.lootBoxImg.y - 200,
                alpha: 1,
                ease: "Power1",
                duration: 2000
            });
            //Block Inputs
            this.BGZone = currentScene.add.zone(0, 0, width, height).setOrigin(0).setInteractive().on("pointerup", function() {});
        }
        this.timedEvent = currentScene.time.delayedCall(1500, onEvent, [], this);
        function onEvent() {
            //Check if legendary Skin was won
            if (skinGiven == true) {
                log("Du hast den " + lootData.OpenBox[1].content + " gewonnen!");
                gameData.Gluecklich = true;
                hintboxSalary.create(currentScene, {
                    posX: centerX * 0.37,
                    posY: centerY,
                    text: "Du hast den " + lootData.OpenBox[1].content + " gewonnen!"
                });
            } else if (crystalsGiven > 0) {
                gameData.Crystals += crystalsGiven;
                currentScene.updateMoneyAndCrystals();
                showTweenText(currentScene, 410, 1080, "#1A9200", "+" + crystalsGiven);
            } else {
                currentScene.audioplayer.playSFX("Empty_Lootbox");
                log("Du hast " + lootData.OpenBox[5].content + " gewonnen!");
                hintbox.create(currentScene, {
                    posX: centerX * 0.37,
                    posY: centerY,
                    text: "Du hast " + lootData.OpenBox[5].content + " gewonnen!"
                });
            }
            game.events.emit("openBox");
        }
    }
};

//# sourceMappingURL=index.2b13affc.js.map
