/*

UI LAYER

*/ var speakerImgInfo = {
    posX: gameConfig.screenResolution.width - 100,
    posY: 50,
    height: 50,
    width: 50
};
var fullscrImgInfo = {
    posX: gameConfig.screenResolution.width - 180,
    posY: 50,
    height: 50,
    width: 50
};
var BuySkinButton;
var ToggleSoundButton;
class UILayer extends Wrapper {
    constructor(){
        super("UILayer");
    }
    preload() {
        this.audioplayer = this.scene.get("Audio");
        this.load.json("loot", "assets/data/loot.json");
    }
    create() {
        let sData;
        sData = this.cache.json.get("loot");
        //Menu Bar to display Money, Crystals and buy legendary Skin
        this.MenuBar = this.add.image(this.sys.canvas.width / 2, 1128, "MenuBar");
        this.MenuBar.setScale(1.85);
        this.euroIcon = this.add.image(70, 1132, "euroIcon");
        this.euroIcon.setScale(1);
        this.crystalicon = this.add.image(350, 1132, "crystalicon");
        this.crystalicon.setScale(1);
        //Money Counter
        this.MoneyDisplay = this.add.text(180, 1130, gameData.Money, {
            align: "left",
            fontFamily: "AkzidenzGrotesk-ExtraBold",
            color: "#050505",
            fontSize: "56px",
            wordWrap: {
                width: 450
            }
        });
        this.MoneyDisplay.setOrigin(0.5);
        //Crystal Counter
        this.CrystalDisplay = this.add.text(455, 1130, gameData.Crystals, {
            align: "left",
            fontFamily: "AkzidenzGrotesk-ExtraBold",
            color: "#050505",
            fontSize: "56px",
            wordWrap: {
                width: 450
            }
        });
        this.CrystalDisplay.setOrigin(0.5);
        //Buy Skin Button
        BuySkinButton = this.add.sprite(850, 1130, "BuySkinBtn").setOrigin(0.5).setInteractive({
            useHandCursor: true
        }).setTint(0xFF7E34, 0xFF6234, 0xFF5D00, 0xFF3A00).on("pointerover", ()=>{
            this.audioplayer.playSFX("ButtonHover");
            BuySkinButton.setDisplaySize(BuySkinButton.displayWidth + 5, BuySkinButton.displayHeight + 5);
        }, this).on("pointerout", ()=>{
            BuySkinButton.setDisplaySize(BuySkinButton.displayWidth - 5, BuySkinButton.displayHeight - 5);
        }, this).on("pointerdown", ()=>{
            this.audioplayer.playSFX("ButtonClick");
            this.buyLegendarySkin(sData);
        });
        //Button for toggling sound
        ToggleSoundButton = this.add.sprite(165, 70, "SoundBtn_on").setOrigin(0.5).setInteractive({
            useHandCursor: true
        }).on("pointerover", ()=>{
            this.audioplayer.playSFX("ButtonHover");
            ToggleSoundButton.setDisplaySize(ToggleSoundButton.displayWidth + 5, ToggleSoundButton.displayHeight + 5);
        }, this).on("pointerout", ()=>{
            ToggleSoundButton.setDisplaySize(ToggleSoundButton.displayWidth - 5, ToggleSoundButton.displayHeight - 5);
        }, this).on("pointerdown", ()=>{
            //this.audioplayer.playSFX ("ButtonClick");
            if (gameData.soundOn) {
                this.audioplayer.setBGMVolume(0);
                this.audioplayer.setSFXVolume(0);
                ToggleSoundButton.setTexture("SoundBtn_off");
                gameData.soundOn = false;
            } else {
                this.audioplayer.setBGMVolume(0.1);
                this.audioplayer.setSFXVolume(0.1);
                ToggleSoundButton.setTexture("SoundBtn_on");
                gameData.soundOn = true;
            }
        });
        if (!gameData.soundOn) ToggleSoundButton.setTexture("SoundBtn_off");
        if (gameConfig.keyboardActive) {
            this.currentKeyboard;
            this.keyboard = this.add.dom(centerX, 800, "div").createFromCache("keyboard").setOrigin(0.5);
            this.keyboard.setVisible(false);
            this.keyboardStyle();
        }
        this.createParticleEmitter();
        this.listenerManager();
    }
    updateMoneyAndCrystals() {
        gameData.Money = roundTwoDecimals(gameData.Money);
        this.CrystalDisplay.text = gameData.Crystals;
        this.MoneyDisplay.text = gameData.Money;
        gameData.Money >= 60 || gameData.Crystals;
    //Revert if conditions become false again
    //else BuySkinButton.clearTint();
    }
    buyLegendarySkin(sData) {
        this.audioplayer.playSFX("ButtonClick");
        var scene01 = this.scene.get("Scene01");
        if (gameData.Crystals >= sData.buySkin.crystal_cost || gameData.Money >= sData.buySkin.money_cost) {
            //Transaction visuals
            if (gameData.Crystals >= sData.buySkin.crystal_cost) {
                gameData.Crystals -= sData.buySkin.crystal_cost;
                showTweenText(this, 410, 1080, "#FF0000", "-" + sData.buySkin.crystal_cost);
            } else if (gameData.Money >= sData.buySkin.money_cost) {
                gameData.Money -= sData.buySkin.money_cost;
                showTweenText(this, 130, 1080, "#FF0000", "-" + sData.buySkin.money_cost + "€");
                gameData.Money_Spent += sData.buySkin.money_cost;
                log("Money Spent: " + gameData.Money_Spent);
            }
            log("Bought the legendary skin! Game Over!");
            this.updateMoneyAndCrystals();
            gameData.Bought_Skin = true;
            this.audioplayer.playSFX("Success");
            this.legendarySkinImg = this.add.image(centerX, centerY, "legendarySkin").setScale(0.3).setDepth(2000);
            this.glowImg = this.add.image(centerX - 10, centerY, "glow").setAlpha(0).setDepth(1900);
            this.tweens.add({
                targets: [
                    this.legendarySkinImg,
                    this.glowImg
                ],
                y: centerY - 200,
                alpha: 1,
                ease: "Power1",
                duration: 2000
            });
            //Block Inputs
            this.BGZone = this.add.zone(0, 0, width, height).setOrigin(0).setInteractive().on("pointerup", function() {});
            this.timedEvent = this.time.delayedCall(2000, onEvent, [], this);
            function onEvent() {
                scene01.gameTimer.stopTimer(true);
                this.scene.stop("Scene01");
                this.scene.stop("UILayer");
                this.scene.start("GameOver");
            }
        } else {
            this.audioplayer.playSFX("Error");
            log("Not enough money or crystals!");
            hintbox.create(this, {
                posX: this.sys.canvas.width * 0.17,
                posY: this.sys.canvas.height * 0.4,
                text: sData.buySkin.errorText
            });
        }
    }
    update() {}
    listenerManager() {
        this.input.on("pointerdown", function(pointer, gameObject, dragX, dragY) {
        //this.explodeParticles('CoinD', pointer.x,pointer.y,5);
        }, this);
    // speakerImg.on("pointerdown", function(pointer) {
    //   toggleSound (this.scene);
    // });
    //
    // fullscreenBtn.on("pointerup", function(pointer) {
    //   if(this.scale.isFullscreen) {
    //     this.scale.stopFullscreen();
    //   } else {
    //     this.scale.startFullscreen();
    //   }
    // }, this);
    }
    keyboardStyle() {
        var keyboardRows = document.getElementById("keyboard").getElementsByTagName("section");
        log(keyboardRows);
        var startY; //starting point of the Y axis
        var baseY = 53; // next row starting Y axis
        for(var i = 0; i < keyboardRows.length; ++i){
            var row = keyboardRows[i];
            var rowKeys = keyboardRows[i].getElementsByTagName("div");
            var startX = -151;
            startY = -106 - baseY * i - i * 7;
            for(var j = 0; j < rowKeys.length; ++j){
                var key = rowKeys[j];
                var inc = this.calcIncrement(key);
                key.style.backgroundPositionX = startX + "px";
                key.style.backgroundPositionY = startY + "px";
                key.addEventListener("click", (e)=>{
                    switch(e.target.title){
                        case "backspace":
                            this.currentKeyboard.value = this.currentKeyboard.value.slice(0, -1);
                            break;
                        case "enter":
                            break;
                        default:
                            this.currentKeyboard.value += e.target.title;
                    }
                });
                startX = startX - inc - 2;
            }
        }
    }
    calcIncrement(key) {
        var classes = key.className.split(" ");
        var inc = new Object();
        var baseX = 56;
        switch(classes[1]){
            case "one":
                inc = baseX;
                break;
            case "one-one-half":
                inc = baseX * 1.5;
                break;
            case "two":
                inc = baseX * 2;
                break;
            case "two-two-half":
                inc = baseX * 2.5;
                break;
            case "three":
                inc = baseX * 3;
                break;
            case "five":
                inc = baseX * 5;
                break;
            default:
        }
        return inc;
    }
    displayKeyboard(input) {
        this.currentKeyboard = input;
        this.keyboard.setVisible(true);
    }
    // === === === === === === === === === === === === === === === === === ===
    // Particles
    createParticleEmitter() {
        var rect = new Phaser.Geom.Rectangle(centerX - 150, 0, 300, 200);
        this.anims.create({
            key: "flipDa",
            frames: this.anims.generateFrameNumbers("CoinD", {
                frames: [
                    0,
                    1,
                    2,
                    3,
                    4
                ]
            }),
            frameRate: 30,
            repeat: -1
        });
        this.anims.create({
            key: "flipDb",
            frames: this.anims.generateFrameNumbers("CoinD", {
                frames: [
                    3,
                    4,
                    0,
                    1,
                    2
                ]
            }),
            frameRate: 30,
            repeat: -1
        });
        this.anims.create({
            key: "flipCa",
            frames: this.anims.generateFrameNumbers("CrystalG", {
                frames: [
                    0,
                    1,
                    2,
                    3
                ]
            }),
            frameRate: 30,
            repeat: -1
        });
        this.anims.create({
            key: "flipCb",
            frames: this.anims.generateFrameNumbers("CrystalG", {
                frames: [
                    3,
                    0,
                    1,
                    2
                ]
            }),
            frameRate: 30,
            repeat: -1
        });
        this.particleEmitterCoins = this.add.particles(0, 0, "CoinD", {
            anim: [
                "flipDa",
                "flipDb"
            ],
            speed: {
                min: 10,
                max: 1000,
                ease: "Expo.easeOut"
            },
            angle: {
                min: 0,
                max: 360
            },
            scale: {
                start: 3,
                end: 3
            },
            gravityY: 500,
            active: false,
            lifespan: 8000
        }).setDepth(1200);
        this.particleEmitterCrystals = this.add.particles(0, 0, "CrystalG", {
            anim: [
                "flipCa",
                "flipCb"
            ],
            speed: {
                min: 10,
                max: 1000,
                ease: "Expo.easeOut"
            },
            angle: {
                min: 0,
                max: 360
            },
            scale: {
                start: 3,
                end: 3
            },
            gravityY: 500,
            active: false,
            lifespan: 8000
        }).setDepth(1200);
        //Junk Emitters
        this.particleEmitterJunk1 = this.add.particles(0, 0, "Junk1", {
            speed: {
                min: 10,
                max: 1000,
                ease: "Expo.easeOut"
            },
            angle: {
                min: 0,
                max: 360
            },
            scale: {
                start: 3,
                end: 3
            },
            gravityY: 500,
            active: false,
            lifespan: 8000
        }).setDepth(1200);
        this.particleEmitterJunk2 = this.add.particles(0, 0, "Junk2", {
            speed: {
                min: 10,
                max: 1000,
                ease: "Expo.easeOut"
            },
            angle: {
                min: 0,
                max: 360
            },
            scale: {
                start: 3,
                end: 3
            },
            gravityY: 500,
            active: false,
            lifespan: 8000
        }).setDepth(1200);
        this.particleEmitterJunk3 = this.add.particles(0, 0, "Junk3", {
            speed: {
                min: 10,
                max: 1000,
                ease: "Expo.easeOut"
            },
            angle: {
                min: 0,
                max: 360
            },
            scale: {
                start: 3,
                end: 3
            },
            depth: 1200,
            gravityY: 500,
            active: false,
            lifespan: 8000
        }).setDepth(1200);
        this.particleEmitterJunk4 = this.add.particles(0, 0, "Junk4", {
            speed: {
                min: 10,
                max: 1000,
                ease: "Expo.easeOut"
            },
            angle: {
                min: 0,
                max: 360
            },
            scale: {
                start: 3,
                end: 3
            },
            depth: 1200,
            gravityY: 500,
            active: false,
            lifespan: 8000
        }).setDepth(1200);
    }
    explodeParticles(particle, x, y, amount = 100) {
        switch(particle){
            case "CoinD":
                this.particleEmitterCoins.resume();
                this.particleEmitterCoins.explode(amount, x, y);
                break;
            case "CrystalG":
                this.particleEmitterCrystals.resume();
                this.particleEmitterCrystals.explode(amount, x, y);
                break;
            case "Junk":
                this.particleEmitterJunk1.resume();
                this.particleEmitterJunk1.explode(amount / 4, x, y);
                this.particleEmitterJunk2.resume();
                this.particleEmitterJunk2.explode(amount / 4, x, y);
                this.particleEmitterJunk3.resume();
                this.particleEmitterJunk3.explode(amount / 4, x, y);
                this.particleEmitterJunk4.resume();
                this.particleEmitterJunk4.explode(amount / 4, x, y);
        }
    }
}

//# sourceMappingURL=index.2e137a6b.js.map
