var textbox = {
    create: function(scene, { centerX , centerY , width , text , fixedWidth =false , fontSize =26 , align ="center"  }) {
        this.box = scene.add.group();
        this.box.name = text;
        var textMarginTop = 36;
        var textMarginBottom = 48;
        var textMarginHorizontal = 36;
        this.textBg = scene.add.image(0, 0, "whiteBox");
        this.boxText = scene.add.text(centerX, centerY, text, {
            fontFamily: "Font",
            color: "#000",
            fontSize: fontSize + "px",
            align: align,
            wordWrap: {
                width: width
            }
        });
        var textAnchor = 1;
        if (align == "left") textAnchor = 1;
        else if (align == "right") textAnchor = 0;
        this.boxText.setOrigin(textAnchor, 0);
        var textBounds = this.boxText.getBounds();
        if (!fixedWidth) this.textBg.setOrigin(0).setDisplaySize(textBounds.width + textMarginHorizontal * 2, textBounds.height + textMarginTop + textMarginBottom).setPosition(textBounds.x - textMarginHorizontal, textBounds.y - textMarginTop);
        else // use fixed width for Quiz boxes etc
        this.textBg.setOrigin(0).setDisplaySize(width, textBounds.height + textMarginTop + textMarginBottom).setPosition(textBounds.x + textMarginHorizontal, textBounds.y);
        this.box.addMultiple([
            this.textBg,
            this.boxText
        ]);
        return this.box;
    }
};

//# sourceMappingURL=index.433cec2f.js.map
