/*

	Dialog Manager
	- starts a new dialog

*/ class DialogManager extends Phaser.Scene {
    constructor(){
        super("DialogManager");
    }
    init() {
        this.currentLocation;
        this.currentDialog;
        this.currentLine;
    }
    preload() {}
    create() {
        var parent = this;
        log("=> launching Dialog manager");
        this.events.on("nextLine", this.nextLine, this);
    }
    update() {}
    startDialog(scene, paraScene, paraDialog, hasButton = true, paraLine = "line0") {
        this.currentLocation = scene;
        this.currentDialog = fullDialog[paraScene][paraDialog];
        this.currentLine = this.currentDialog[paraLine];
        this.callbacks = {
            before: this.currentLine.callback.before,
            after: this.currentLine.callback.after
        };
        return dialog.create(scene, {
            name: this.currentLine.speaker,
            btnText: "Weiter",
            sprite: this.currentLine.sprite,
            text: this.currentLine.text,
            voiceover: this.currentLine.voiceover,
            nextLine: this.currentLine.nextLine,
            callback: this.callbacks,
            hasButton: hasButton
        });
    }
    nextLine(nextLine) {
        if (this.currentLine.nextLine) {
            let oldSpeaker = this.currentLine.speaker;
            let newSpeaker = this.currentDialog[this.currentLine.nextLine].speaker;
            // set new line
            this.currentLine = this.currentDialog[this.currentLine.nextLine];
            this.callbacks = {
                before: this.currentLine.callback.before,
                after: this.currentLine.callback.after
            };
            if (oldSpeaker != newSpeaker) {
                dialog.closeMe();
                dialog.create(this.currentLocation, {
                    name: this.currentLine.speaker,
                    btnText: "Weiter",
                    text: this.currentLine.text,
                    voiceover: this.currentLine.voiceover,
                    nextLine: this.currentLine.nextLine,
                    sprite: this.currentLine.sprite,
                    callback: this.callbacks
                });
            } else if (oldSpeaker == newSpeaker) dialog.newText({
                text: this.currentLine.text,
                voiceover: this.currentLine.voiceover,
                nextLine: this.currentLine.nextLine,
                callback: this.callbacks
            });
            else dialog.closeMe();
        }
    }
}

//# sourceMappingURL=index.50f6eca1.js.map
