var vid;
var videobox = {
    rewind: function() {},
    create: function(scene, { centerX , centerY , path , callback ={
        before: null,
        after: null
    } , loop =false  }) {
        var parent = this;
        var type = "vid";
        var title = title;
        this.callbacks = callback;
        this.callbacks.before();
        this.container = scene.add.container(0, 0);
        this.videoGroup = scene.add.group();
        this.isOpen = true;
        this.vid;
        this.bgBox = scene.add.graphics();
        this.bgBox.fillStyle(0x000000, 1);
        this.bgBox.fillRoundedRect(0, 0, scene.game.config.width, scene.game.config.height, 0);
        this.bgBox.alpha = 0;
        scene.tweens.add({
            targets: this.bgBox,
            alpha: 0.8,
            ease: "Sine.InOut",
            duration: 500
        });
        this.closeOnClickZone = scene.add.zone(0, 0, scene.game.config.width, scene.game.config.height).setOrigin(0).setInteractive().on("pointerdown", ()=>{
        // nada
        });
        this.skipBtn = scene.add.sprite(scene.game.config.width - 150, scene.game.config.height - 80, "SkipButton").on("pointerdown", ()=>{
            this.vid.destroy();
            this.skipBtn.destroy();
            this.bgBox.destroy();
            this.closeOnClickZone.destroy();
            this.runCallback(scene);
        }).on("pointerover", ()=>{}).on("pointerout", ()=>{}).setInteractive({
            useHandCursor: true
        }).setOrigin(0.5);
        this.skipBtn.setVisible(false);
        // player actions
        if (type == "vid") {
            scene.cache.video.remove("vid");
            scene.load.video("vid", path);
            scene.load.once(Phaser.Loader.Events.COMPLETE, ()=>{
                if (this.isOpen == true) {
                    this.vid = scene.add.video(0, 0, "vid");
                    this.vid.setOrigin(0);
                    this.vid.removeVideoElementOnDestroy = true;
                    this.vid.name = "video";
                    this.vid.play(loop);
                    this.vid.on("unlocked", function(ev) {
                        log("VID unlocked!", ev);
                    }, this);
                    this.vid.on("stop", function(ev) {
                        log("VID stop!", ev);
                    }, this);
                    this.vid.on("play", function(ev) {
                        log("VID START!", ev);
                        this.skipBtn.setVisible(true);
                    }, this);
                    if (!loop) this.vid.on("complete", function(ev) {
                        log("VID complete!", ev);
                        this.vid.destroy();
                        this.skipBtn.destroy();
                        this.bgBox.destroy();
                        this.closeOnClickZone.destroy();
                        this.runCallback(scene);
                    }, this);
                    this.videoGroup.addMultiple([
                        this.vid
                    ]);
                    this.videoGroup.setVisible(true);
                    this.bgBox.setDepth(1);
                    this.vid.setDepth(9);
                    this.skipBtn.setDepth(10);
                }
            }, this);
            scene.load.start();
        }
    },
    runCallback: function(sc) {
        this.callbacks.after();
    },
    destroyMe: function(sc, type) {
        var scene = sc;
        if (type == "vid") {
            if (scene.vid) {
                scene.vid.setCurrentTime(0);
                scene.vid.stop();
                scene.vid.destroy();
                scene.vid.name = "";
            }
        }
        scene.popBox.destroy();
        scene.titleText.destroy();
        scene.closeOnClickZone.destroy();
        scene.bgBox.destroy();
        scene.isOpen = false;
    }
};

//# sourceMappingURL=index.555ac9d8.js.map
