/*

          CREDITS

*/ class Credits extends Wrapper {
    constructor(){
        super("Credits");
    }
    preload() {
        this.audioplayer = this.scene.get("Audio");
        this.load.image("truckBg", "assets/backgrounds/TruckBg.png");
        this.load.json("loot", "assets/data/loot.json");
    }
    create() {
        sData = this.cache.json.get("loot");
        this.dZone = this.add.zone(0, 0, width, height).setOrigin(0).setInteractive().on("pointerup", function() {});
        this.Bg = this.add.image(centerX, centerY, "truckBg").setDisplaySize(this.sys.canvas.width, this.sys.canvas.height).setOrigin(0);
        this.btnClose = this.add.image(centerX + 300, centerY + 530, "button_small").setInteractive({
            useHandCursor: true
        }).on("pointerover", function(pointer) {
            this.audioplayer.playSFX("ButtonHover");
            this.btnClose.setDisplaySize(this.btnClose.displayWidth + 5, this.btnClose.displayHeight + 5);
        }, this).on("pointerout", function(pointer) {
            this.btnClose.setDisplaySize(this.btnClose.displayWidth - 5, this.btnClose.displayHeight - 5);
        }, this);
        /*.on('pointerdown', () => {
      
      this.scene.start('GameOver');
     
    }, this)*/ this.Bg.setOrigin(0.5);
        this.btnClose.setScale(1);
        this.Bg.setAlpha(0);
        this.btnCloseTxt = this.add.text(this.btnClose.x, this.btnClose.y - 5, "Zur\xfcck", {
            align: "center",
            fontFamily: "Impact",
            color: "Black",
            stroke: "White",
            strokeThickness: 1,
            fontSize: "34px",
            wordWrap: {
                width: 450
            }
        });
        this.btnCloseTxt.setOrigin(0.5).setShadow(0, 4, "rgba(0,0,0,0.25)", 5);
        //BG Animation
        this.tweens.add({
            targets: this.Bg,
            scale: {
                start: 1.2,
                from: 1.2,
                to: 1
            },
            alpha: {
                start: 0,
                from: 0,
                to: 0.9
            },
            ease: "Sine.InOut",
            duration: 500
        });
        this.textDisplay = this.add.text(centerX, 400, sData.Credits.text, {
            align: "center",
            fontFamily: gameConfig.defaultFont,
            color: "#FFFFFF",
            fontSize: "38px",
            wordWrap: {
                width: 450
            }
        });
        this.textDisplay.setOrigin(0.5);
        this.timedEvent = this.time.delayedCall(1000, onEvent, [], this);
        function onEvent() {
            this.tweens.add({
                targets: this.textDisplay,
                y: -1000,
                duration: 10000
            });
        }
        this.listenerManager(this);
    }
    update() {}
    listenerManager(sc) {
        var parent = sc;
        this.btnClose.on("pointerdown", function(pointer) {
            parent.audioplayer.playSFX("ButtonClick");
            parent.tweens.add({
                targets: parent.Bg,
                scale: {
                    start: 1,
                    from: 1,
                    to: 1.2
                },
                alpha: {
                    start: 1,
                    from: 1,
                    to: 0
                },
                ease: "Sine.InOut",
                duration: 500,
                onComplete: ()=>{
                    parent.scene.stop("Credits");
                    parent.scene.start("GameOver");
                }
            });
        });
    }
}

//# sourceMappingURL=index.6e8669db.js.map
