/*
Slotmachine based on https://phasergames.com/downloads/slot-machine-game-starter-kit/
*/ var slotMachine = {
    currentScene: null,
    slotData: null,
    preload: function() {
        this.audioplayer = this.scene.get("Audio");
    },
    create: function(scene, sData) {
        //creating new slot machine...
        this.slotMachine = scene.add.group();
        //this.spinTimer;
        currentScene = scene;
        slotData = sData;
        this.BGZone = scene.add.zone(0, 0, width, height).setOrigin(0).setInteractive().on("pointerup", function() {});
        //
        //add bar
        //
        this.barStartingY = centerY + 320;
        if (this.bar != undefined) this.bar.destroy();
        this.bar = scene.add.image(centerX - 45, this.barStartingY, "bars");
        this.bar.setVisible(true);
        this.bar.setActive(true);
        //Create mask to hide excess spinner bar
        this.shape = scene.add.graphics();
        this.shape.fillStyle(0xFF0000, 0);
        this.shape.fillRect(centerX - 150, centerY - 235, 300, 300);
        this.mask = this.shape.createGeometryMask();
        this.bar.setMask(this.mask);
        //Set bar to random position
        this.setBar(Math.floor(random() * (Object.keys(slotData.Lottery).length - 1)));
        this.slotMachineOverlay = scene.add.image(centerX + 12, centerY - 50, "lotteryBG");
        //this.slotMachineOverlay.setAlpha(0.8);
        this.btnSpin = scene.add.image(centerX, centerY * 1.45, "button_small").setInteractive({
            useHandCursor: true
        }).on("pointerover", ()=>{
            scene.audioplayer.playSFX("ButtonHover");
            this.btnSpin.setDisplaySize(this.btnSpin.displayWidth + 5, this.btnSpin.displayHeight + 5);
        }).on("pointerout", ()=>{
            scene.audioplayer.playSFX("ButtonHover");
            this.btnSpin.setDisplaySize(this.btnSpin.displayWidth - 5, this.btnSpin.displayHeight - 5);
        }).on("pointerdown", ()=>{
            gameData.Lottery_Clicks += 1;
            gameData.Money -= sData.Lottery.cost;
            log("Lottery Button Clicks: " + gameData.Lottery_Clicks);
            gameData.Money_Spent += sData.Lottery.cost;
            log("Money Spent: " + gameData.Money_Spent);
            scene.updateMoneyAndCrystals();
            showTweenText(scene, 130, 1080, "#FF0000", "-" + sData.Lottery.cost + "€");
            scene.audioplayer.playSFX("ButtonClick");
            scene.audioplayer.playSFX("Lottery");
            this.btnBack.input.enabled = false;
            this.startSpin();
        });
        this.spinText = scene.add.text(centerX, centerY * 1.44, "Start", {
            align: "center",
            fontFamily: "Impact",
            color: "Black",
            stroke: "White",
            strokeThickness: 1,
            fontSize: "34px",
            wordWrap: {
                width: 450
            }
        }).setOrigin(0.5).setShadow(0, 4, "rgba(0,0,0,0.25)", 5);
        this.btnBack = scene.add.image(centerX * 1.71, centerY * 1.42, "BackBtn").setScale(1).setInteractive({
            useHandCursor: true
        }).on("pointerover", ()=>{
            scene.audioplayer.playSFX("ButtonHover");
            this.btnBack.setDisplaySize(this.btnBack.displayWidth + 5, this.btnBack.displayHeight + 5);
        }).on("pointerout", ()=>{
            scene.audioplayer.playSFX("ButtonHover");
            this.btnBack.setDisplaySize(this.btnBack.displayWidth - 5, this.btnBack.displayHeight - 5);
        }).on("pointerdown", ()=>{
            this.slotMachine.clear(true, true);
            this.slotMachine.destroy();
            scene.audioplayer.playSFX("ButtonClick");
            return;
        });
        this.slotMachine.addMultiple([
            this.BGZone,
            this.bar,
            this.slotMachineOverlay,
            this.btnSpin,
            this.spinText,
            this.btnBack
        ]);
        return this.slotMachine;
    },
    killMe: function() {
        this.bar.destroy();
        this.slotMachine.clear(true, true);
    },
    startSpin () {
        log("startSpin");
        this.bar.x = centerX - 45;
        this.bar.y = centerY - 150;
        this.spinning = true;
        this.btnSpin.visible = false;
        this.spinText.visible = false;
        //set which value to stop on
        var resultIndex;
        var resultAssigned = false;
        //Random value between 1 and 1000
        var lotteryResult = Math.floor(random() * 1000) + 1;
        log("lotteryResult:" + lotteryResult);
        //Last result has 100% chance since it is always given out if no other result was assigned
        for(var i = 1; i < Object.keys(slotData.Lottery).length; i++)if (lotteryResult <= slotData.Lottery[i].chance * 10 && resultAssigned == false) {
            resultIndex = i;
            log("resultIndex: " + resultIndex);
            resultAssigned = true;
            break;
        }
        this.setStop(resultIndex);
        //
        //set a timer to spin the wheels
        //
        this.spinTimer = new Event(currentScene.time.addEvent({
            delay: 10,
            callback: this.spin,
            callbackScope: this,
            loop: true
        }));
    },
    setStop (stopPoint) {
        this.bar.stopPoint = stopPoint;
        this.bar.activated = true;
        this.bar.spins = Math.floor(random() * 2) + 1;
        log("Spins: " + this.bar.spins);
    },
    setBar (pos) {
        log("Set bar at index:" + (pos + 1));
        this.bar.y = this.barStartingY - pos * 100;
    },
    //loop through the bar groupy
    //and move each bar up by the number of spins it
    //has left by 2
    spin () {
        if (this.bar.activated == true) {
            this.bar.y -= this.bar.spins * 8;
            if (this.bar.y > this.barStartingY) this.bar.y = this.barStartingY;
            //if the bar is at the end of a spin
            //which is when the y position
            //is less than the negative height of the bar
            //
            if (this.bar.y < this.barStartingY - 800) {
                this.bar.y = this.barStartingY;
                //then subtract a spin
                this.bar.spins--;
                //if out of spins then
                if (this.bar.spins == 0) {
                    this.bar.activated = false;
                    //do the final spin
                    //which is a tween
                    log("Out of spins!");
                    this.finalSpin(this.bar);
                }
            }
        }
    },
    finalSpin (bar) {
        var ty = this.barStartingY - (bar.stopPoint - 1) * 100;
        var finalTween = currentScene.tweens.add({
            targets: bar,
            y: ty,
            duration: 980,
            onComplete: function() {
                log("EVENT LISTENERS 'finishSpin': ", game.events.listeners("finishSpin"));
                log("bar.stopPoint: " + bar.stopPoint);
                log("Slotmachine reward " + slotData.Lottery[bar.stopPoint].lootboxes);
                gameData.SlotMachine_Reward = slotData.Lottery[bar.stopPoint].lootboxes;
                game.events.emit("finishSpin");
            }
        });
    }
};

//# sourceMappingURL=index.82131c1c.js.map
