/*

    Quiz Minigame / Manager

*/ class Quiz extends Wrapper {
    constructor(){
        super("Quiz");
    }
    init(data) {
        log("QUIZ DATA: ", data);
        this.data = data;
        this.dialogRef = data.dialog;
    }
    preload() {}
    create() {
        var parent = this;
        this.blockZone = this.add.zone(0, 0, this.game.config.width, this.game.config.height).setOrigin(0).setInteractive().on("pointerdown", function() {
            console.log("INPUTS BLOCKED!");
        });
        var startY = 200;
        var stepY = 130;
        var zoneOffsetX = 0;
        var zoneOffsetY = -50;
        this.tBox1 = textbox.create(this, {
            centerX: centerX,
            centerY: startY + stepY * 0,
            text: "Antwort 1",
            align: "left",
            width: 800,
            fontSize: 32,
            fixedWidth: true
        });
        var pos = {
            x: this.tBox1.children.entries[0].x,
            y: this.tBox1.children.entries[0].y
        };
        this.t1Zone = this.add.zone(pos.x + zoneOffsetX, pos.y + zoneOffsetY, 800, 100).setOrigin(0);
        this.tBox2 = textbox.create(this, {
            centerX: centerX,
            centerY: startY + stepY * 1,
            text: "Antwort 2",
            align: "left",
            width: 800,
            fontSize: 32,
            fixedWidth: true
        });
        pos = {
            x: this.tBox2.children.entries[0].x,
            y: this.tBox2.children.entries[0].y
        };
        this.t2Zone = this.add.zone(pos.x + zoneOffsetX, pos.y + zoneOffsetY, 800, 100).setOrigin(0);
        this.tBox3 = textbox.create(this, {
            centerX: centerX,
            centerY: startY + stepY * 2,
            text: "Antwort 3",
            align: "left",
            width: 800,
            fontSize: 32,
            fixedWidth: true
        });
        pos = {
            x: this.tBox3.children.entries[0].x,
            y: this.tBox3.children.entries[0].y
        };
        this.t3Zone = this.add.zone(pos.x + zoneOffsetX, pos.y + zoneOffsetY, 800, 100).setOrigin(0);
        this.tBox4 = textbox.create(this, {
            centerX: centerX,
            centerY: startY + stepY * 3,
            text: "Antwort 4",
            align: "left",
            width: 800,
            fontSize: 32,
            fixedWidth: true
        });
        pos = {
            x: this.tBox4.children.entries[0].x,
            y: this.tBox4.children.entries[0].y
        };
        this.t4Zone = this.add.zone(pos.x + zoneOffsetX, pos.y + zoneOffsetY, 800, 100).setOrigin(0);
        this.tBox1.setOrigin(0, 0.5);
        this.tBox2.setOrigin(0, 0.5);
        this.tBox3.setOrigin(0, 0.5);
        this.tBox4.setOrigin(0, 0.5);
        for(var i = 1; i <= 4; i++)this["tBox" + i].setVisible(false);
        setTimeout(()=>{
            parent.listenerManager();
            this.createQuiz();
        }, 1500);
    }
    update() {}
    createQuiz() {
        var answers = this.data.map[this.data.npc].answers;
        //log ("answers: ",answers);
        for(var j = 1; j <= Object.keys(answers).length; j++)//log("unlocked:",j,answers[j].unlocked);
        if (answers[j].unlocked == true) {
            this["tBox" + j].setVisible(true);
            this["t" + j + "Zone"].setInteractive();
            this["tBox" + j].children.entries[1].text = answers[j].text;
            log("answers[j].unlockPopped: ", answers[j].unlockPopped);
            if (!answers[j].unlockPopped) {
                answers[j].unlockPopped = true;
                this["tBox" + j].getChildren().forEach(function(child) {
                    child.setAlpha(0);
                    var endScale = child.scale;
                    this.tweens.add({
                        targets: child,
                        alpha: {
                            from: 0,
                            to: 1
                        },
                        scale: {
                            from: 1.2,
                            to: endScale
                        },
                        ease: "Sine.InOut",
                        delay: (j - 1) * 200,
                        duration: 1000,
                        onComplete: ()=>{}
                    });
                }, this);
            }
        }
    }
    destroyQuiz(zoneClicked) {
        for(var i = 1; i <= 4; i++)this["tBox" + i].destroy(true);
        this.data.quizScene.newAnswer = {
            npc: this.data.npc,
            answer: zoneClicked
        };
        this.data.callback(zoneClicked);
        this.dialogRef.closeMe();
        this.data.scene.stop("Quiz");
    }
    listenerManager() {
        var parent = this;
        this.t1Zone.setInteractive({
            useHandCursor: true
        }).on("pointerdown", function() {
            //log("t1Zone", parent.dialogRef);
            parent.destroyQuiz(1);
        });
        this.t1Zone.disableInteractive();
        this.t2Zone.setInteractive({
            useHandCursor: true
        }).on("pointerdown", function() {
            //log("t2Zone");
            parent.destroyQuiz(2);
        });
        this.t2Zone.disableInteractive();
        this.t3Zone.setInteractive({
            useHandCursor: true
        }).on("pointerdown", function() {
            //log("t3Zone");
            parent.destroyQuiz(3);
        });
        this.t3Zone.disableInteractive();
        this.t4Zone.setInteractive({
            useHandCursor: true
        }).on("pointerdown", function() {
            //log("t4Zone");
            parent.destroyQuiz(4);
        });
        this.t4Zone.disableInteractive();
        this.data.quizScene.newAnswer = null;
    }
}

//# sourceMappingURL=index.847bf0cc.js.map
