/*
My idea is for this class to be the duplicable class, allowing easy start on the next scene with a basic framework.
*/ var sData;
class Scene01 extends Phaser.Scene {
    constructor(){
        super("Scene01");
    }
    preload() {
        this.audioplayer = this.scene.get("Audio");
        this.uiLayer = this.scene.get(gameConfig.uiLayer);
        this.load.image("truckBg", "assets/backgrounds/TruckBg.png");
        this.load.json("loot", "assets/data/loot.json");
        this.gameTimer = this.scene.get("Gametimer");
    }
    create() {
        gameData.Money = gameData.startingMoney;
        gameData.Crystals = gameData.startingCrystals;
        this.scene.launch(gameConfig.uiLayer);
        //Start music loop
        this.audioplayer.playBGM("2");
        //Create game timer
        this.gameTimer.newTimer(this, {
            gameTime: gameConfig.gameTimeInSeconds,
            delay: 0,
            posX: centerX + 8,
            posY: 600,
            countdown: true,
            callback: ()=>{
                this.audioplayer.playSFX("Timeout");
                this.gameTimer.stopTimer(true);
                this.scene.stop("UILayer");
                this.scene.start("GameOver");
            }
        }, this);
        this.gameTimer.startAnim(gameConfig.gameTimeInSeconds);
        //Create back button
        this.backButton = this.add.sprite(807, -200, "BackBtn").setScale(1).setInteractive({
            useHandCursor: true
        }).setDepth(800).setVisible(false).on("pointerover", ()=>{
            this.audioplayer.playSFX("ButtonHover");
            this.backButton.setDisplaySize(this.backButton.displayWidth + 5, this.backButton.displayHeight + 5);
        }).on("pointerout", ()=>{
            this.audioplayer.playSFX("ButtonHover");
            this.backButton.setDisplaySize(this.backButton.displayWidth - 5, this.backButton.displayHeight - 5);
        }).on("pointerdown", ()=>{
            this.goBack();
            this.audioplayer.playSFX("ButtonClick");
        });
        //Create home button
        this.homeButton = this.add.sprite(927, -200, "HomeBtn").setScale(1).setInteractive({
            useHandCursor: true
        }).setDepth(800).setVisible(false).on("pointerover", ()=>{
            this.audioplayer.playSFX("ButtonHover");
            this.homeButton.setDisplaySize(this.homeButton.displayWidth + 5, this.homeButton.displayHeight + 5);
        }).on("pointerout", ()=>{
            this.audioplayer.playSFX("ButtonHover");
            this.homeButton.setDisplaySize(this.homeButton.displayWidth - 5, this.homeButton.displayHeight - 5);
        }).on("pointerdown", ()=>{
            this.goHome();
            this.audioplayer.playSFX("ButtonClick");
        });
        var previousScreen;
        // Assign an object to store the loaded data
        sData = this.cache.json.get("loot");
        //create research text array
        let textArray;
        //Populate and shuffle text array
        textArray = this.populateResearchTextArray(sData, textArray);
        //Assign Background Object
        gameData.Bg = this.add.image(this.sys.canvas.width / 2, this.sys.canvas.height / 2, "truckBg").setOrigin(0.5).setScale(1.1);
        this.cMain = this.createButtonGrid(this, {
            sData: sData,
            textArray: textArray,
            buttonSize: 380,
            buttonSpacing: 120,
            containerName: "Main",
            screenKey: sData.screens.main,
            containerX: centerX,
            containerY: centerY,
            moveX: 0,
            moveY: -1,
            visible: true
        });
        this.cMain.bgColors = [
            "#4782E9",
            "#005CFF",
            "#4173CB",
            "#0048C8"
        ];
        this.cKristalle = this.createButtonGrid(this, {
            sData: sData,
            textArray: textArray,
            buttonSize: 380,
            buttonSpacing: 120,
            containerName: "Kristalle",
            screenKey: sData.screens.main.Kristalle,
            containerX: centerX,
            containerY: centerY,
            moveX: 0,
            moveY: -1,
            visible: false
        });
        this.cKristalle.bgColors = [
            "#3FDDCA",
            "#00DCC2",
            "#3CB4A6",
            "#00AF9B"
        ];
        this.cLootbox = this.createButtonGrid(this, {
            sData: sData,
            textArray: textArray,
            buttonSize: 380,
            buttonSpacing: 120,
            containerName: "Lootbox",
            screenKey: sData.screens.main.Lootbox,
            containerX: centerX,
            containerY: centerY,
            moveX: 0,
            moveY: -1,
            visible: false
        });
        this.cLootbox.bgColors = [
            "#F9C232",
            "#FFB900",
            "#DCAF39",
            "#D79C00"
        ];
        this.cLootboxPakete = this.createButtonGrid(this, {
            sData: sData,
            textArray: textArray,
            buttonSize: 380,
            buttonSpacing: 120,
            containerName: "LootboxPakete",
            screenKey: sData.screens.main.Pakete,
            containerX: centerX,
            containerY: centerY,
            moveX: 0,
            moveY: -1,
            visible: false
        });
        this.cLootboxPakete.bgColors = [
            "#C35AFF",
            "#BC47FF",
            "#9244BF",
            "#7B00C2"
        ];
        this.currentScreen = this.cMain;
        this.nextScreen;
    }
    //Populate and shuffle research text array
    populateResearchTextArray(sData, textArray) {
        textArray = Object.keys(sData.screens.main.Recherche.content);
        log("textArray.length after repopulate: " + textArray.length);
        //Shuffle text Array
        for(var i = textArray.length - 1; i > 0; i--){
            var j = Math.floor(random() * (i + 1));
            var temp = textArray[i];
            textArray[i] = textArray[j];
            textArray[j] = temp;
        }
        return textArray;
    }
    drawBackground(previousBgColors, bgColors) {
        var previousTints = previousBgColors;
        this.tweens.addCounter({
            from: 1,
            to: 100,
            duration: 650,
            onUpdate: function(tween) {
                const value = Math.floor(tween.getValue());
                gameData.Bg.setTint(blend_colors(previousTints[0], bgColors[0], value * 0.01), blend_colors(previousTints[1], bgColors[1], value * 0.01), blend_colors(previousTints[2], bgColors[2], value * 0.01), blend_colors(previousTints[3], bgColors[3], value * 0.01));
            }
        });
    }
    createButtonGrid(scene, { sData , textArray , buttonSize , buttonSpacing , containerName , containerX , containerY , moveX , moveY , screenKey , visible =true  }) {
        // Calculate the total width and height of the button grid
        const gridWidth = 2 * buttonSize + buttonSpacing;
        const gridHeight = 2 * buttonSize + buttonSpacing;
        // Calculate the starting x and y positions of the button grid
        const xStart = -gridWidth / 2;
        const yStart = -gridHeight / 2;
        // Get the keys of the main object in sData
        const screenKeys = Object.keys(screenKey);
        // Create the container
        const container = scene.add.container(containerX, containerY).setName(containerName);
        // Create each button and add it to the container
        for(let i = 0; i < 4; i++){
            const x = xStart + i % 2 * (buttonSize + buttonSpacing) + 8; // Calculate the x position of the button
            const y = yStart + Math.floor(i / 2) * (buttonSize + buttonSpacing); // Calculate the y position of the button
            // Create the button as an image object
            const button = scene.add.image(x, y, "sdBtn").setDisplaySize(buttonSize, buttonSize).setOrigin(0).setTint(screenKey[screenKeys[i]].color);
            log(screenKey[screenKeys[i]], " -> screenKeys "); // , screenKey.screenKeys[i].text
            container.add([
                button
            ]);
            const buttonZone = scene.add.zone(x + buttonSize / 2, y + buttonSize / 2, buttonSize * 1, buttonSize * 1);
            buttonZone.setDepth(900);
            container.add([
                buttonZone
            ]);
            var buttonText;
            if (screenKey[screenKeys[i]] != undefined) {
                // Add text to the button from the sData object
                buttonText = scene.add.text(x + buttonSize / 2 - 6, y + buttonSize / 2 - 6, screenKey[screenKeys[i]].text, {
                    fontFamily: "Impact",
                    color: "Black",
                    stroke: "White",
                    strokeThickness: 1,
                    fontSize: "38px",
                    align: "center"
                }).setOrigin(0.5);
                container.add([
                    buttonText
                ]);
            }
            //Assign listener to button zone
            buttonZone.setInteractive({
                useHandCursor: true
            }).on("pointerover", ()=>{
                this.audioplayer.playSFX("ButtonHover");
                button.x = x - 7;
                button.y = y - 7;
                button.setDisplaySize(buttonSize + 15, buttonSize + 15);
            }).on("pointerout", ()=>{
                button.x = x;
                button.y = y;
                button.setDisplaySize(buttonSize, buttonSize);
            }).on("pointerdown", ()=>{
                button.x = x;
                button.y = y;
                button.setDisplaySize(buttonSize, buttonSize);
                this.audioplayer.playSFX("ButtonClick");
                //button.setTint(0xD5E8EC);
                //Clear Button tint after 0.3 seconds
                /*this.timedEvent = this.time.delayedCall(300, onEvent, [], this);
            function onEvent() {
              button.clearTint();
            }*/ log(`Button ${screenKeys[i]} was clicked!`);
                this.nextScreen = this["c" + screenKeys[i]];
                //Navigation between screens
                if (this.nextScreen !== undefined) {
                    this.hideButtonGrid(this.currentScreen, moveX, moveY);
                    this.showButtonGrid(this.currentScreen, this.nextScreen, 0, 1);
                    //this.drawBackground(this.currentScreen, container.bgColors);
                    this.previousScreen = this.currentScreen;
                    this.currentScreen = this.nextScreen;
                }
            });
            //More elegant way to assign button functions?
            switch(container.name){
                case "Main":
                    //Assign Research button function
                    if (screenKeys[i] == screenKeys[1]) buttonZone.setInteractive({
                        useHandCursor: true
                    }).on("pointerdown", ()=>{
                        this.audioplayer.playSFX("Research");
                        this.timedEvent = this.time.delayedCall(1000, this.audioplayer.playSFX("Book"), [], this);
                        gameData.Research_Clicks += 1;
                        log("Research Button Clicks: " + gameData.Research_Clicks);
                        //Display text in hintbox
                        hintbox.create(this.uiLayer, {
                            posX: this.sys.canvas.width * 0.19,
                            posY: this.sys.canvas.height * 0.25,
                            text: screenKey[screenKeys[i]].content[textArray[0]]
                        });
                        if (textArray.length > 1) textArray.shift();
                        else textArray = this.populateResearchTextArray(sData, textArray);
                        log("textArray.length: " + textArray.length);
                    });
                    //Assign Lohn Button function
                    if (screenKeys[i] == screenKeys[3]) {
                        this.minusOneSec = this.add.image(793, 915, "minusOneSec");
                        this.minusOneSec.setDepth(700);
                        buttonZone.setInteractive({
                            useHandCursor: true
                        }).on("pointerdown", ()=>{
                            gameData.Salary_Clicks += 1;
                            log("Salary Button Clicks: " + gameData.Salary_Clicks);
                            //Attempt to get salary
                            this.getSalary(sData);
                        });
                    }
                    break;
                case "Kristalle":
                    buttonZone.setInteractive({
                        useHandCursor: true
                    }).on("pointerdown", ()=>{
                        this.buyCrystals(screenKey[screenKeys[i]].cost, screenKey[screenKeys[i]].crystals);
                    });
                    break;
                case "Lootbox":
                    //Lootbox Pakete Button
                    if (screenKeys[i] == screenKeys[0]) buttonZone.setInteractive({
                        useHandCursor: true
                    }).on("pointerdown", ()=>{
                        log(`Button ${screenKeys[i]} was clicked!`);
                        this.currentScreen = this["cLootbox"];
                        this.nextScreen = this["cLootboxPakete"];
                        //Navigation between screens
                        if (this.nextScreen !== undefined) {
                            this.hideButtonGrid(this.currentScreen, moveX, moveY);
                            this.showButtonGrid(this.currentScreen, this.nextScreen, 0, 1);
                            //this.drawBackground( this.currentScreen, container.bgColors);
                            //previous screen is lootboxes
                            this.previousScreen = this.currentScreen;
                            //current screen is lootbox packs
                            this.currentScreen = this.nextScreen;
                        }
                    });
                    //Lootbox lottery
                    if (screenKeys[i] == screenKeys[1]) buttonZone.setInteractive({
                        useHandCursor: true
                    }).on("pointerdown", ()=>{
                        this.gambleForLootBox(sData.Lottery.cost, sData);
                    });
                    //Buy 2 Lootboxes
                    if (screenKeys[i] == screenKeys[2]) buttonZone.setInteractive({
                        useHandCursor: true
                    }).on("pointerdown", ()=>{
                        this.buyLootBox(sData, sData.screens.main.Lootbox[3].amount, false, sData.screens.main.Lootbox[3].cost);
                    });
                    //Buy 50 Lootboxes
                    if (screenKeys[i] == screenKeys[3]) buttonZone.setInteractive({
                        useHandCursor: true
                    }).on("pointerdown", ()=>{
                        this.buyLootBox(sData, sData.screens.main.Lootbox[4].amount, false, sData.screens.main.Lootbox[4].cost);
                    });
                    break;
                case "LootboxPakete":
                    //Buy 1 Lootbox
                    if (screenKeys[i] == screenKeys[0]) buttonZone.setInteractive({
                        useHandCursor: true
                    }).on("pointerdown", ()=>{
                        this.buyLootBox(sData, sData.screens.main.Pakete[1].amount, true, sData.screens.main.Pakete[1].cost);
                    });
                    //Buy 5 Lootbox
                    if (screenKeys[i] == screenKeys[1]) buttonZone.setInteractive({
                        useHandCursor: true
                    }).on("pointerdown", ()=>{
                        this.buyLootBox(sData, sData.screens.main.Pakete[2].amount, true, sData.screens.main.Pakete[2].cost);
                    });
                    //Buy 9 Lootbox
                    if (screenKeys[i] == screenKeys[2]) buttonZone.setInteractive({
                        useHandCursor: true
                    }).on("pointerdown", ()=>{
                        this.buyLootBox(sData, sData.screens.main.Pakete[3].amount, true, sData.screens.main.Pakete[3].cost);
                    });
                    //Buy 30 Lootbox
                    if (screenKeys[i] == screenKeys[3]) buttonZone.setInteractive({
                        useHandCursor: true
                    }).on("pointerdown", ()=>{
                        this.buyLootBox(sData, sData.screens.main.Pakete[4].amount, true, sData.screens.main.Pakete[4].cost);
                    });
                    break;
            }
        } //End of for-loop
        container.setVisible(visible);
        return container;
    }
    hideButtonGrid(container, moveX, moveY) {
        var BlockInteractionZone = this.add.zone(0, 0, width, height).setOrigin(0).setInteractive().on("pointerup", function() {});
        container.add([
            BlockInteractionZone
        ]);
        // Calculate the new x position for the button
        const newX = container.x + width * moveX;
        const newY = container.y + height * moveY;
        // Create a tween to animate the button to its new x position
        this.tweens.add({
            targets: container,
            x: newX,
            y: newY,
            duration: 500,
            ease: "Back.In",
            onComplete: ()=>{
                container.setVisible(false);
                BlockInteractionZone.destroy();
            }
        });
        //Hide minus 1 sec icon
        if (container == this.cMain) this.tweens.add({
            targets: this.minusOneSec,
            x: this.minusOneSec.x,
            y: -50,
            alpha: 0.5,
            duration: 500,
            ease: "Back.In",
            onComplete: ()=>{
                this.minusOneSec.setVisible(false);
            }
        });
    }
    showButtonGrid(previousContainer, container, moveX, moveY) {
        container.setVisible(true);
        log("Container Name: " + container.containerName);
        //this.drawBackground(previousContainer.bgColors, container.bgColors)
        const newX = container.x + width * moveX;
        const newY = container.y + height * moveY;
        container.x = newX;
        container.y = newY;
        // Create a tween to animate the button to its new x position
        this.tweens.add({
            targets: container,
            x: centerX,
            y: centerY,
            duration: 500,
            ease: "Back.In"
        });
        if (container == this.cMain) {
            this.minusOneSec.setVisible(true);
            this.tweens.add({
                targets: this.minusOneSec,
                x: this.minusOneSec.x,
                y: 915,
                alpha: 1,
                duration: 500,
                ease: "Back.In"
            });
            //Tween out navigation buttons
            this.tweens.add({
                targets: this.homeButton,
                x: this.homeButton.x,
                y: -60,
                duration: 500,
                ease: "Back.In",
                onComplete: ()=>{
                    this.homeButton.setVisible(false);
                }
            });
            this.tweens.add({
                targets: this.backButton,
                x: this.backButton.x,
                y: -60,
                duration: 500,
                ease: "Back.In",
                onComplete: ()=>{
                    this.backButton.setVisible(false);
                }
            });
        } else {
            //Tween in navigation buttons
            this.homeButton.setVisible(true);
            this.tweens.add({
                targets: this.homeButton,
                x: this.homeButton.x,
                y: 70,
                duration: 500,
                ease: "Back.In",
                onComplete: ()=>{}
            });
            this.backButton.setVisible(true);
            this.tweens.add({
                targets: this.backButton,
                x: this.backButton.x,
                y: 70,
                duration: 500,
                ease: "Back.In",
                onComplete: ()=>{}
            });
        }
        log("current Container:" + container.name);
    }
    goHome() {
        //return if already on home screen
        if (this.currentScreen == this.cMain) return;
        const screenKeys = Object.keys(this.cMain);
        //hide current screen with animation
        this.hideButtonGrid(this.currentScreen, 0, 1);
        //Hide Lootbox screen properly after Packs page is opened
        this.hideButtonGrid(this.cLootbox, 0, 1);
        this.showButtonGrid(this.currentScreen, this.cMain, 0, -1);
        this.currentScreen = this.cMain;
    }
    goBack() {
        //return if already on home screen
        if (this.currentScreen == this.cMain) return;
        const screenKeys = Object.keys(this.cMain);
        //hide current screen with animation
        this.hideButtonGrid(this.currentScreen, 0, 1);
        this.showButtonGrid(this.currentScreen, this.previousScreen, 0, -1);
        this.currentScreen = this.previousScreen;
        if (this.currentScreen == this.cLootbox) this.previousScreen = this.cMain;
    }
    getSalary(sData) {
        var salaryResult = Math.floor(random() * 100) + 1; //TODO: Chances for success?
        log("salaryResult:" + salaryResult);
        //Got Money :)
        if (salaryResult <= sData.screens.main.Lohn.chance) {
            this.audioplayer.playSFX("Salary");
            this.timedEvent = this.time.delayedCall(1000, this.audioplayer.playSFX("Coins"), [], this);
            //Show transaction text
            showTweenText(this.uiLayer, 110, 1080, "#1A9200", " +" + sData.screens.main.Lohn.amount);
            gameData.Money += sData.screens.main.Lohn.amount; //TODO: How much money?
            this.uiLayer.updateMoneyAndCrystals();
            this.uiLayer.explodeParticles("CoinD", game.input.mousePointer.x, game.input.mousePointer.y, sData.screens.main.Lohn.amount);
            this.hintboxSalary = hintboxSalary.create(this.uiLayer, {
                posX: this.sys.canvas.width * 0.185,
                posY: this.sys.canvas.height * 0.6,
                text: sData.screens.main.Lohn.erhalten
            });
            this.timedEvent = this.time.delayedCall(1000, onEvent, [], this);
            function onEvent() {
                log("Clear hintbox!");
                this.hintboxSalary.clear(true, true);
            }
        } else {
            this.audioplayer.playSFX("Salary_Failed");
            //Get random text if no salary was received
            var TextID = Math.floor(random() * 3) + 1;
            var wartenText = "warten" + TextID;
            this.hintboxSalary = hintboxSalary.create(this.uiLayer, {
                posX: this.sys.canvas.width * 0.185,
                posY: this.sys.canvas.height * 0.6,
                text: sData.screens.main.Lohn[wartenText]
            });
            this.timedEvent = this.time.delayedCall(1000, onEvent, [], this);
            function onEvent() {
                log("Clear hintbox!");
                this.hintboxSalary.clear(true, true);
            }
        }
    }
    buyCrystals(cost, crystals) {
        if (gameData.Money >= cost) {
            gameData.Money_Spent += cost;
            log("Money Spent: " + gameData.Money_Spent);
            this.audioplayer.playSFX("Crystal");
            //Show transaction text
            showTweenText(this.uiLayer, 410, 1080, "#1A9200", "+" + crystals);
            showTweenText(this.uiLayer, 100, 1080, "#FF0000", "-" + cost + "€");
            //Create Crystal Particles
            this.uiLayer.explodeParticles("CrystalG", game.input.mousePointer.x, game.input.mousePointer.y, crystals / 100);
            gameData.Money -= cost;
            gameData.Crystals += crystals;
            log("Bought " + crystals + " Crystals for " + cost + " Euros!");
            this.uiLayer.updateMoneyAndCrystals();
            //Disable Effizient Result
            gameData.Efficient_Buyer = false;
        } else {
            this.audioplayer.playSFX("Error");
            log("Not Enough Money!");
        }
    }
    //Lootbox lottery
    gambleForLootBox(cost, sData) {
        var prizeAmount;
        var prizeGiven = false;
        if (gameData.Money >= cost) {
            this.slotMachine = slotMachine.create(this.uiLayer, sData);
            game.events.on("finishSpin", this.finishSpinHandler, this);
        } else {
            this.audioplayer.playSFX("Error");
            log("Not enough Money!");
        }
    }
    finishSpinHandler() {
        var lootBoxesWon = gameData.SlotMachine_Reward;
        log("lootBoxesWon: " + lootBoxesWon);
        gameData.SlotMachine_Reward = 0;
        //Set Kristallklar Result (back) to false if Lootboxes were bought with money more than twice
        gameData.Money_Purchases += 1;
        if (gameData.Money_Purchases > sData.results["3"].max_money_purchases) {
            gameData.Kristallklar = false;
            log("Kristallklar: " + gameData.Kristallklar);
        }
        //Disable Effizient Result
        gameData.Efficient_Buyer = false;
        this.timedEvent = null;
        this.timedEvent = this.time.delayedCall(1000, onEvent, [], this);
        function onEvent() {
            game.events.removeListener("finishSpin");
            slotMachine.killMe();
            this.openLootBox(sData, lootBoxesWon);
        }
    }
    buyLootBox(sData, amount, buyWithMoney, currency) {
        if (buyWithMoney) {
            //Check if player has enough money
            if (gameData.Money >= currency) {
                gameData.Money -= currency;
                gameData.Money_Spent += currency;
                log("Money Spent: " + gameData.Money_Spent);
                log("Bought " + amount + " lootboxes for " + currency + " Euros!");
                this.uiLayer.updateMoneyAndCrystals();
                showTweenText(this.uiLayer, 100, 1080, "#FF0000", "-" + currency + "€");
                //Set Kristallklar Result (back) to false if Lootboxes were bought with money more than twice
                gameData.Money_Purchases += 1;
                if (gameData.Money_Purchases > sData.results["3"].max_money_purchases) {
                    gameData.Kristallklar = false;
                    log("Kristallklar: " + gameData.Kristallklar);
                }
                //If any purchase other than the 30 Lootboxes was made, disable Effizient result
                if (amount != sData.screens.main.Pakete["4"].amount) {
                    gameData.Efficient_Buyer = false;
                    log("Efficient Buyer:" + gameData.Efficient_Buyer);
                }
                //Check for Effizient result
                if (amount == sData.screens.main.Pakete["4"].amount && gameData.Money <= 37.00 && gameData.Efficient_Buyer) {
                    gameData.Effizient = true;
                    log("Effizient: " + gameData.Effizient);
                }
                //Check if Silver Pack was bought
                if (amount == 5) {
                    gameData.Silver_Pack_Purchases += 1;
                    log("Silver Pack Purchases: " + gameData.Silver_Pack_Purchases);
                }
                this.openLootBox(sData, amount);
            } else {
                this.audioplayer.playSFX("Error");
                log("Not enough Money!");
            }
        } else //Check if player has enough crystals
        if (gameData.Crystals >= currency) {
            gameData.Crystals -= currency;
            log("Bought " + amount + " lootboxes for " + currency + " crystals!");
            this.uiLayer.updateMoneyAndCrystals();
            showTweenText(this.uiLayer, 410, 1080, "#FF0000", "-" + currency);
            //Set Kristallklar Result to true (false later if Lootboxes are bought with Money)
            if (gameData.Money_Purchases <= sData.results["3"].max_money_purchases) {
                gameData.Kristallklar = true;
                log("Kristallklar: " + gameData.Kristallklar);
            }
            this.openLootBox(sData, amount);
        } else {
            this.audioplayer.playSFX("Error");
            log("Not enough Crystals!");
        }
    }
    openLootBox(sData, amount) {
        if (amount == 0 || amount == null) {
            log("Error! No lootboxes to open!");
            return;
        }
        this.lootBoxScreen = LootboxScreen.create(this.uiLayer, amount, sData);
        game.events.on("openBox", ()=>{
            this.events.off("openBox");
            this.lootBoxScreen.clear(true, true);
            //Go to Gameover screen if legendary skin was won
            if (gameData.Gluecklich == true) {
                this.timedEvent = this.time.delayedCall(2500, onEvent, [], this);
                function onEvent() {
                    this.gameTimer.stopTimer(true);
                    this.scene.stop("Scene01");
                    this.scene.stop("UILayer");
                    this.scene.start("GameOver");
                }
            }
        }, this);
    }
    update() {}
}

//# sourceMappingURL=index.8899be89.js.map
