var hintbox = {
    create: function(scene, { posX , posY , text , audioplayer , startGame  }) {
        this.hintbox = scene.add.group();
        var textMarginTop = 120;
        var textMarginBottom = 48;
        var textMarginHorizontal = 126;
        //TODO: Disable hand pointer
        this.hintBGZone = scene.add.zone(0, 0, width, height).setOrigin(0).setInteractive({
            useHandCursor: false
        }).on("pointerup", function() {});
        this.hintBg = scene.add.image(0, 0, "HintPopup");
        this.hintBg.setScale(1);
        this.hintText = scene.add.text(posX, posY, text, {
            fontFamily: "TheSansMono-8-Bold",
            color: "#000",
            fontSize: "30px",
            align: "left",
            wordWrap: {
                width: 700
            }
        });
        var textBounds = this.hintText.getBounds();
        this.hintBg.setOrigin(0).setPosition(textBounds.x - textMarginHorizontal, textBounds.y - textMarginTop);
        this.hintInteractiveZone = scene.add.zone(this.hintBg.x + 750, this.hintBg.y + 430, 400, 150);
        this.hintbox.addMultiple([
            this.hintBGZone,
            this.hintBg,
            this.hintText,
            this.hintInteractiveZone
        ]);
        this.hintInteractiveZone.setInteractive({
            useHandCursor: true
        }).on("pointerdown", function() {
            this.hintbox.clear(true, true);
            if (startGame) {
                audioplayer.playSFX("StartButton");
                scene.scene.start("Scene01");
                scene.scene.bringToTop(gameConfig.uiLayer);
            }
        }, this);
        this.hintbox.setDepth(999);
        return this.hintbox;
    }
};

//# sourceMappingURL=index.9311260a.js.map
