/*

          Main menu

*/ var dialogManager;
class MainMenu extends Wrapper {
    constructor(){
        super("MainMenu");
    }
    preload() {
        this.load.image("menuBG", "assets/backgrounds/TruckBg.png");
        this.audioplayer = this.scene.get("Audio");
        this.load.json("loot", "assets/data/loot.json");
    }
    create() {
        dialogManager = this.scene.get("DialogManager");
        this.menuBG = this.add.image(0, 0, "menuBG").setDisplaySize(this.sys.canvas.width, this.sys.canvas.height).setOrigin(0);
        sData = this.cache.json.get("loot");
        this.Logo = this.add.image(centerX + 6, centerY - 385, "Logo");
        this.startBtn = this.add.image(centerX + 8, centerY + 10, "sdStart");
        this.startBtn.setScale(1.2);
        this.startBtn.setInteractive({
            useHandCursor: true
        });
        this.listenerManager(this);
    }
    update() {}
    listenerManager(scene) {
        this.startBtn.on("pointerover", function(pointer) {
            this.audioplayer.playSFX("ButtonHover");
            this.startBtn.setDisplaySize(this.startBtn.displayWidth + 10, this.startBtn.displayHeight + 10);
        }, this);
        this.startBtn.on("pointerout", function(pointer) {
            this.startBtn.setDisplaySize(this.startBtn.displayWidth - 10, this.startBtn.displayHeight - 10);
        }, this);
        this.startBtn.on("pointerdown", function(pointer) {
            this.audioplayer.playSFX("ButtonClick");
            //If tutorial hasn't been shown before (first run)
            if (!gameData.TutorialSeen) hintboxTutorial.create(scene, this.audioplayer, sData, {
                posX: centerX * 0.35,
                posY: centerY
            });
            else {
                log("Runs: " + gameData.Runs);
                //Create Array with NewGame Texts
                if (gameData.Runs <= 1) {
                    log("Making Text Array...");
                    NewGameTexts = Object.keys(sData.NewGame);
                }
                if (gameData.Runs > 10) {
                    log("Schowing Final Gametext");
                    hintbox.create(scene, {
                        posX: this.sys.canvas.width * 0.19,
                        posY: this.sys.canvas.height * 0.3,
                        text: "Schon " + gameData.Runs + "x gespielt, , ist das schon Sucht? Komm schon, du schaffst es das n\xe4chste mal!",
                        audioplayer: this.audioplayer,
                        startGame: true
                    });
                } else {
                    log("Schowing Gametext");
                    hintbox.create(scene, {
                        posX: this.sys.canvas.width * 0.19,
                        posY: this.sys.canvas.height * 0.3,
                        //text: sData.NewGame[NewGameTexts[0]],
                        text: sData.NewGame[NewGameTexts[0]],
                        audioplayer: this.audioplayer,
                        startGame: true
                    });
                    NewGameTexts.shift();
                }
            //Shuffle new Game Texts
            /*for (var i = NewGameTexts.length - 1; i > 0; i--){
          var j = Math.floor(random() * (i + 1));
          var temp = NewGameTexts[i];
          NewGameTexts[i] = NewGameTexts[j];
          NewGameTexts[j] = temp;
        }*/ }
            gameData.TutorialSeen = true;
        }, this);
    }
}

//# sourceMappingURL=index.9cdb12d5.js.map
