/*
Create a dialog modal popup inside a given scene
*/ var dialog = {
    create: function(scene, { name ="NAME" , text ="TEXT" , btnText ="WEITER" , voiceover ="ButtonClick" , hasEnded =true , hasButton =true , nextLine =null , sprite ="DialogChar" , callback ={
        before: null,
        after: null
    }  }) {
        scene.intervalId = null;
        this.voiceover = voiceover;
        this.sc = scene;
        this.animationSpeedFactor = 0.35;
        this.cb = callback;
        this.mText = text;
        this.nextLine = nextLine;
        scene.scene.get("Modal").blockInputs();
        if (this.voiceover != null && this.voiceover != false) scene.audioplayer.playSound(this.voiceover, {});
        // CALLBACK BEFORE
        if (this.cb.before != null) {
            scene.tmpFunc = new Function(this.cb.before);
            scene.tmpFunc();
        }
        scene.dZoneBG = scene.add.rectangle(0, 0, width, height, 0x000000);
        scene.dZoneBG.setAlpha(0.8);
        scene.dZoneBG.setOrigin(0);
        scene.dZone = scene.add.zone(0, 0, width, height).setOrigin(0).setInteractive().on("pointerup", function() {});
        scene.dChar = scene.add.image(250, height - 150, sprite);
        scene.dBG = scene.add.image(centerX + 50, height - 170, "DialogBG");
        scene.dBtn = scene.add.image(scene.dBG.x + 450, scene.dBG.y + 110, "DialogBtn");
        scene.dName = scene.add.image(scene.dBG.x - 250, scene.dBG.y - 140, "DialogNameBG");
        var textMarginTop = 36;
        var textMarginBottom = 48;
        var textMarginHorizontal = 36;
        scene.dTextName = scene.add.text(scene.dName.x - 210, scene.dName.y, name, {
            fontFamily: "FontBold",
            color: "#000",
            fontSize: "42px"
        });
        scene.dTextName.setOrigin(0, 0.5);
        scene.dTextButton = scene.add.text(scene.dBtn.x, scene.dBtn.y, btnText, {
            fontFamily: "FontBold",
            color: "#000",
            fontSize: "36px"
        });
        scene.dTextButton.setOrigin(0.5);
        scene.dText = scene.add.text(scene.dBG.x - 470, scene.dBG.y - 80, "", {
            fontFamily: "FontMedium",
            color: "#000",
            fontSize: "32px",
            wordWrap: {
                width: width * 0.5
            }
        });
        scene.dText.setOrigin(0);
        // Animations
        scene.tweens.add({
            targets: [
                scene.dZoneBG
            ],
            alpha: {
                start: 0,
                from: 0,
                to: 0.8
            },
            ease: "Sine.InOut",
            duration: 500 * this.animationSpeedFactor
        });
        scene.tweens.add({
            targets: [
                scene.dBG,
                scene.dChar
            ],
            alpha: {
                start: 0,
                from: 0,
                to: 1
            },
            ease: "Sine.InOut",
            duration: 1000 * this.animationSpeedFactor
        });
        scene.tweens.add({
            targets: [
                scene.dChar
            ],
            x: {
                start: -250,
                from: -250,
                to: 250
            },
            ease: "Sine.InOut",
            duration: 1000 * this.animationSpeedFactor
        });
        scene.tweens.add({
            targets: [
                scene.dBG
            ],
            y: {
                start: height + 170,
                from: height + 170,
                to: height - 170
            },
            ease: "Sine.InOut",
            duration: 1000 * this.animationSpeedFactor,
            delay: 500 * this.animationSpeedFactor
        });
        scene.tweens.add({
            targets: [
                scene.dTextName,
                scene.dTextButton,
                scene.dText,
                scene.dBtn,
                scene.dName
            ],
            alpha: {
                start: 0,
                from: 0,
                to: 1
            },
            ease: "Sine.InOut",
            duration: 250 * this.animationSpeedFactor,
            delay: 1000 * this.animationSpeedFactor,
            onComplete: ()=>{
                this.typewrite(scene, scene.dText, text, scene.intervalId);
                scene.dBtn.setInteractive({
                    useHandCursor: true
                });
                scene.scene.get("Modal").blockInputs(false);
            }
        });
        if (!hasButton) {
            scene.dBtn.setVisible(false);
            scene.dTextButton.setVisible(false);
        }
        var parent = this;
        scene.dBtn.on("pointerup", function() {
            if (parent.sc.intervalId != null) {
                clearInterval(parent.sc.intervalId);
                parent.sc.intervalId = null;
                parent.sc.dText.text = parent.mText;
                return;
            }
            if (parent.nextLine != null && parent.nextLine != false) {
                parent.sc.dText.text = "";
                // delay the new dialog box a bit to make sure all vars are reset
                setTimeout(()=>{
                    parent.sc.scene.get("DialogManager").events.emit("nextLine");
                }, 25);
            } else parent.closeMe();
        });
        // return for optional referencing
        return this;
    },
    newText: function(data) {
        // in case there's another line of dialog, DO NOT close the dialog
        // clear the text and start a new typewriter instead!
        //log ("TEXT FOR SAME NPC! new data:", data);
        this.sc.dText.text = "";
        this.cb = data.callback;
        this.mText = data.text;
        this.nextLine = data.nextLine;
        this.voiceover = data.voiceover;
        this.sc.audioplayer.stopSounds();
        if (this.voiceover != null && this.voiceover != false) this.sc.audioplayer.playSound(this.voiceover, {});
        this.typewrite(this.sc, this.sc.dText, this.mText, this.sc.intervalId);
    },
    closeMe: function() {
        var parent = this;
        this.sc.audioplayer.playSFX("ButtonClick");
        if (this.voiceover != null && this.voiceover != false) this.sc.audioplayer.stopSound(this.voiceover);
        clearInterval(this.sc.intervalId);
        this.sc.scene.get("Modal").blockInputs();
        this.sc.dZone.destroy();
        this.sc.tweens.add({
            targets: [
                this.sc.dChar
            ],
            x: {
                from: 250,
                to: -250
            },
            ease: "Sine.InOut",
            duration: 1000 * this.animationSpeedFactor,
            onComplete: function() {
                //  log("callback on complete: ", parent.cb.after);
                if (parent.cb.after != null && parent.cb.after != "null") {
                    //log("--> run the callback!");
                    parent.sc.tmpFunc = new Function(parent.cb.after);
                    parent.sc.tmpFunc();
                    parent.sc.tmpFunc = null;
                }
                setTimeout(()=>{
                    parent.sc.scene.get("Modal").blockInputs(false);
                }, 250);
                for (var obj of this.targets)obj.destroy();
            }
        });
        this.sc.tweens.add({
            targets: [
                this.sc.dZoneBG
            ],
            alpha: {
                from: 0.8,
                to: 0
            },
            ease: "Sine.InOut",
            duration: 500 * this.animationSpeedFactor,
            onComplete: function() {
                for (var obj of this.targets)obj.destroy();
            }
        });
        this.sc.tweens.add({
            targets: [
                this.sc.dBG,
                this.sc.dTextName,
                this.sc.dTextButton,
                this.sc.dText,
                this.sc.dBtn,
                this.sc.dName
            ],
            //  alpha:    {from: 1, to: 0},
            y: "+=500",
            ease: "Sine.Out",
            duration: 500 * this.animationSpeedFactor,
            onComplete: function() {
                for (var obj of this.targets)obj.destroy();
            }
        });
    },
    typewrite: function(scene, textObj, text) {
        var i = 0;
        var textLength = text.length;
        scene.intervalId = setInterval(()=>{
            if (i <= textLength) {
                scene.dText.text = text.substring(0, i);
                i++;
            } else {
                clearInterval(scene.intervalId);
                scene.intervalId = null;
                scene.scene.get("Modal").blockInputs(false);
            }
        }, 25);
    }
};

//# sourceMappingURL=index.ae57ac07.js.map
