/*

          Game Won
*/ class GameOver extends Wrapper {
    constructor(){
        super("GameOver");
    }
    preload() {
        this.audioplayer = this.scene.get("Audio");
        this.load.image("truckBg", "assets/backgrounds/TruckBg.png");
    }
    create() {
        let sData1;
        sData1 = this.cache.json.get("loot");
        var skinStartingY = this.sys.canvas.height / 2 - 410;
        if (gameData.Bought_Skin | gameData.Gluecklich) {
            this.legendarySkinImg = this.add.image(this.sys.canvas.width / 2, skinStartingY, "legendarySkin").setScale(0.2).setDepth(2000);
            this.glowImgSkin = this.add.image(this.sys.canvas.width / 2 - 10, skinStartingY, "glow").setAlpha(0.7).setDepth(1900).setScale(0.8);
            this.tweens.add({
                targets: [
                    this.legendarySkinImg,
                    this.glowImgSkin
                ],
                y: skinStartingY - 30,
                alpha: 1,
                ease: Phaser.Math.Easing.Sine.InOut,
                yoyo: true,
                repeat: -1,
                duration: 4000
            });
            this.tweens.add({
                targets: this.glowImgSkin,
                alpha: 0.9,
                ease: Phaser.Math.Easing.Sine.InOut,
                yoyo: true,
                repeat: -1,
                duration: 7000
            });
        }
        gameData.Bg = this.add.image(this.sys.canvas.width / 2, this.sys.canvas.height / 2, "truckBg").setOrigin(0.5).setScale(1.7);
        this.resultBg = this.add.image(this.sys.canvas.width / 2, this.sys.canvas.height * 0.45, "gameOverBG").setOrigin(0.5).setTint("0xEAF7FF");
        ToggleSoundButton = this.add.sprite(120, 90, "SoundBtn_on").setOrigin(0.5).setInteractive({
            useHandCursor: true
        }).on("pointerover", ()=>{
            this.audioplayer.playSFX("ButtonHover");
            ToggleSoundButton.setDisplaySize(ToggleSoundButton.displayWidth + 5, ToggleSoundButton.displayHeight + 5);
        }, this).on("pointerout", ()=>{
            ToggleSoundButton.setDisplaySize(ToggleSoundButton.displayWidth - 5, ToggleSoundButton.displayHeight - 5);
        }, this).on("pointerdown", ()=>{
            if (gameData.soundOn) {
                this.audioplayer.setBGMVolume(0);
                this.audioplayer.setSFXVolume(0);
                ToggleSoundButton.setTexture("SoundBtn_off");
                gameData.soundOn = false;
            } else {
                this.audioplayer.setBGMVolume(0.1);
                this.audioplayer.setSFXVolume(0.1);
                ToggleSoundButton.setTexture("SoundBtn_on");
                gameData.soundOn = true;
            }
        });
        //Set correct texture if sound is already off
        if (!gameData.soundOn) ToggleSoundButton.setTexture("SoundBtn_off");
        this.textDisplay = this.add.text(centerX, centerY - 270, "GAME OVER", {
            align: "center",
            fontFamily: "TheSansMono-8-Bold",
            color: "#000000",
            fontSize: "38px",
            wordWrap: {
                width: 450
            }
        });
        this.textDisplay.setOrigin(0.5);
        this.listenerManager();
        this.resultDisplay = this.add.text(centerX, centerY - 100, "result...", {
            align: "center",
            fontFamily: "TheSansMono-8-Bold",
            color: "#000000",
            fontSize: "26px",
            wordWrap: {
                width: 450
            }
        });
        this.resultDisplay.setOrigin(0.5);
        this.textDisplay.setOrigin(0.5);
        //Check which result conditions are met
        this.getResult();
        //Main Game Button
        this.SpielfieberButton = this.add.image(centerX, centerY + 365, "button_large").setOrigin(0.5).setInteractive({
            useHandCursor: true
        }).setTint("0xFFA072").on("pointerover", function(pointer) {
            this.audioplayer.playSFX("ButtonHover");
            this.SpielfieberButton.setDisplaySize(this.SpielfieberButton.displayWidth + 5, this.SpielfieberButton.displayHeight + 5);
        }, this).on("pointerout", function(pointer) {
            this.SpielfieberButton.setDisplaySize(this.SpielfieberButton.displayWidth - 5, this.SpielfieberButton.displayHeight - 5);
        }, this).on("pointerdown", ()=>{
            //this.audioplayer.playSFX ("ButtonClick");
            window.open("https://www.spielfieber.net/spielen/");
        });
        this.SpielfieberText = this.add.text(centerX, this.SpielfieberButton.y, "Check das Spiel:\n Spielfieber", {
            align: "center",
            fontFamily: "Impact",
            color: "Black",
            stroke: "White",
            strokeThickness: 2,
            fontSize: "44px",
            wordWrap: {
                width: 450
            }
        }).setOrigin(0.5).setShadow(0, 4, "rgba(0,0,0,0.25)", 5);
        //Restart Game Button
        this.playAgainButton = this.add.image(centerX + 300, centerY - 480, "button_small").setOrigin(0.5).setScale(1).setInteractive({
            useHandCursor: true
        }).on("pointerover", function(pointer) {
            this.audioplayer.playSFX("ButtonHover");
            this.playAgainButton.setDisplaySize(this.playAgainButton.displayWidth + 5, this.playAgainButton.displayHeight + 5);
            this.playAgainText.text = "Nochmal!";
        }, this).on("pointerout", function(pointer) {
            this.playAgainButton.setDisplaySize(this.playAgainButton.displayWidth - 5, this.playAgainButton.displayHeight - 5);
            this.playAgainText.text = "Nochmal?";
        }, this).on("pointerdown", ()=>{
            this.audioplayer.playSFX("ButtonClick");
            this.audioplayer.stopBGM();
            //Reset all the things
            gameData.Money = gameData.startingMoney;
            gameData.Crystals = gameData.startingCrystals;
            gameData.Salary_Clicks = 0;
            gameData.Lottery_Clicks = 0;
            gameData.Research_Clicks = 0;
            gameData.Money_Purchases = 0;
            gameData.Efficient_Buyer = true;
            gameData.Silver_Pack_Purchases = 0;
            gameData.Bought_Skin = false;
            gameData.Kristallklar = false;
            gameData.Effizient = false;
            gameData.Gluecklich = false;
            gameData.Ungeplant = false;
            gameData.Versilbert = false;
            gameData.Money_Spent = 0, gameData.Lootboxes_Opened = 0;
            gameConfig.gameTimeInSeconds = gameData.startingTime;
            gameData.Runs += 1;
            this.scene.start("MainMenu");
        });
        this.playAgainText = this.add.text(centerX + 300, centerY - 485, "Nochmal?", {
            align: "center",
            fontFamily: "Impact",
            color: "Black",
            stroke: "White",
            strokeThickness: 1,
            fontSize: "34px",
            wordWrap: {
                width: 450
            }
        }).setOrigin(0.5).setShadow(0, 4, "rgba(0,0,0,0.25)", 5);
        //Show stats Button
        this.InfoButton = this.add.image(centerX, centerY + 110, "button_small").setOrigin(0.5).setScale(1).setInteractive({
            useHandCursor: true
        }).setTint("0xD5F1FF").on("pointerover", function(pointer) {
            this.audioplayer.playSFX("ButtonHover");
            this.InfoButton.setDisplaySize(this.InfoButton.displayWidth + 5, this.InfoButton.displayHeight + 5);
        }, this).on("pointerout", function(pointer) {
            this.InfoButton.setDisplaySize(this.InfoButton.displayWidth - 5, this.InfoButton.displayHeight - 5);
        }, this).on("pointerdown", ()=>{
            this.audioplayer.playSFX("ButtonClick");
            gameData.Money_Spent = roundTwoDecimals(gameData.Money_Spent);
            hintboxResults.create(this, {
                posX: centerX * 0.35,
                posY: centerY - 100,
                text: "Geld: " + gameData.Money + " Euro" + "\nKristalle: " + gameData.Crystals + "\nEchtgeld-K\xe4ufe: " + gameData.Money_Purchases + "\nAusgegebenes Geld: " + gameData.Money_Spent + " Euro" + "\n" + "\nGe\xf6ffnete Lootboxen: " + gameData.Lootboxes_Opened + "\nAuf Lohn gewartet: " + gameData.Salary_Clicks + " mal" + "\nRecherchiert: " + gameData.Research_Clicks + " mal" + "\nLotterie-Spins: " + gameData.Lottery_Clicks + "\nGekaufte Silberpakete: " + gameData.Silver_Pack_Purchases
            });
        }, this);
        this.InfoText = this.add.text(centerX, centerY + 105, "Statistik", {
            align: "center",
            fontFamily: "Impact",
            color: "Black",
            stroke: "White",
            strokeThickness: 1,
            fontSize: "34px",
            wordWrap: {
                width: 450
            }
        }).setOrigin(0.5).setShadow(0, 4, "rgba(0,0,0,0.25)", 5);
        //Show Credits Button
        this.CreditsButton = this.add.image(centerX - 295, centerY + 530, "button_small").setOrigin(0.5).setScale(1).setInteractive({
            useHandCursor: true
        }).on("pointerover", function(pointer) {
            this.audioplayer.playSFX("ButtonHover");
            this.CreditsButton.setDisplaySize(this.CreditsButton.displayWidth + 5, this.CreditsButton.displayHeight + 5);
        }, this).on("pointerout", function(pointer) {
            this.CreditsButton.setDisplaySize(this.CreditsButton.displayWidth - 5, this.CreditsButton.displayHeight - 5);
        }, this).on("pointerdown", ()=>{
            this.audioplayer.playSFX("ButtonClick");
            //this.scene.start('Credits');
            window.open("https://www.spielfieber.net/impressum/");
        }, this);
        this.CreditsText = this.add.text(this.CreditsButton.x, this.CreditsButton.y - 5, "Credits", {
            align: "center",
            fontFamily: "Impact",
            color: "Black",
            stroke: "White",
            strokeThickness: 1,
            fontSize: "34px",
            wordWrap: {
                width: 450
            }
        }).setOrigin(0.5).setShadow(0, 4, "rgba(0,0,0,0.25)", 5);
        //Take Screenshot Button
        this.ScreenshotButton = this.add.image(centerX + 295, centerY + 530, "button_small").setOrigin(0.5).setScale(1).setInteractive({
            useHandCursor: true
        }).on("pointerover", function(pointer) {
            this.audioplayer.playSFX("ButtonHover");
            this.ScreenshotButton.setDisplaySize(this.ScreenshotButton.displayWidth + 5, this.ScreenshotButton.displayHeight + 5);
        }, this).on("pointerout", function(pointer) {
            this.ScreenshotButton.setDisplaySize(this.ScreenshotButton.displayWidth - 5, this.ScreenshotButton.displayHeight - 5);
        }, this).on("pointerdown", ()=>{
            this.audioplayer.playSFX("ButtonClick");
            game.renderer.snapshot((image)=>{
                this.exportCanvasAsPNG(image, "Screenshot", image.src);
            });
        }, this);
        this.ScreenshotText = this.add.text(this.ScreenshotButton.x, this.ScreenshotButton.y - 5, "Screenshot machen", {
            align: "center",
            fontFamily: "Impact",
            color: "Black",
            stroke: "White",
            strokeThickness: 1,
            fontSize: "34px",
            wordWrap: {
                width: 450
            }
        }).setOrigin(0.5).setShadow(0, 4, "rgba(0,0,0,0.25)", 5);
    }
    getResult() {
        //Put button click data in array and sort by amount
        var clicksArray = [
            gameData.Salary_Clicks,
            gameData.Lottery_Clicks,
            gameData.Research_Clicks
        ];
        clicksArray.sort();
        clicksArray.reverse();
        //Results are checked in order of Priority list (https://docs.google.com/spreadsheets/d/1k_KnJJ_LFypGGDD2vkn0k6lmHz_oFRTZ1I7AaCUzJtA/edit#gid=0)
        //Result 1: Glücksabhängig
        if (gameData.Lottery_Clicks >= sData.results["1"].minimum_clicks) {
            this.textDisplay.text = sData.results["1"].name;
            this.resultDisplay.text = sData.results["1"].text;
            return;
        } else if (gameData.Effizient == true) {
            this.textDisplay.text = sData.results["2"].name;
            this.resultDisplay.text = sData.results["2"].text;
            return;
        } else if (gameData.Kristallklar == true) {
            this.textDisplay.text = sData.results["3"].name;
            this.resultDisplay.text = sData.results["3"].text;
            return;
        } else if (gameData.Silver_Pack_Purchases >= sData.results["4"].silver_packs_to_purchase) {
            this.textDisplay.text = sData.results["4"].name;
            this.resultDisplay.text = sData.results["4"].text;
            return;
        } else if (gameData.Gluecklich == true) {
            this.textDisplay.text = sData.results["5"].name;
            this.resultDisplay.text = sData.results["5"].text;
            return;
        } else if (clicksArray[0] > 0 && clicksArray[0] == gameData.Salary_Clicks) {
            this.textDisplay.text = sData.results["6"].name;
            this.resultDisplay.text = sData.results["6"].text;
            return;
        } else if (gameData.Research_Clicks >= sData.results["7"].minimum_clicks) {
            this.textDisplay.text = sData.results["7"].name;
            this.resultDisplay.text = sData.results["7"].text;
            return;
        } else {
            this.textDisplay.text = sData.results["8"].name;
            this.resultDisplay.text = sData.results["8"].text;
        }
    }
    exportCanvasAsPNG(id, fileName, dataUrl) {
        var canvasElement = document.getElementById(id);
        var MIME_TYPE = "image/png";
        var imgURL = dataUrl;
        var dlLink = document.createElement("a");
        dlLink.download = fileName;
        dlLink.href = imgURL;
        dlLink.dataset.downloadurl = [
            MIME_TYPE,
            dlLink.download,
            dlLink.href
        ].join(":");
        document.body.appendChild(dlLink);
        dlLink.click();
        document.body.removeChild(dlLink);
    }
    update() {}
    listenerManager() {}
}

//# sourceMappingURL=index.d0832d56.js.map
