var preloaderBar = {
    create: function(scene, { posX , posY , callback  }) {
        scene.cameras.main.fadeIn(200);
        var parent = this;
        var barX = posX;
        var barY = posY;
        this.sc = scene;
        this.callback = callback;
        this.loaderGroup = scene.add.group();
        this.done = false;
        // Add loading screen bars
        this.loadBg = scene.add.image(0, 0, "menuBG").setDisplaySize(scene.sys.canvas.width, scene.sys.canvas.height).setOrigin(0);
        this.loaderBarBorder = scene.add.image(barX + 50, barY, "LoaderBarBorder").setOrigin(0, 0.5).setScale(1, 1);
        this.loaderBarBorder.setDepth(6);
        this.loaderBarBG = scene.add.image(barX + 50, barY, "LoaderBarBg").setOrigin(0, 0.5).setScale(1, 1);
        this.loaderBarBG.setDepth(4);
        //this.loaderBarBG.setTint ('#FFFFFF');
        this.loaderBar = scene.add.image(barX + 60, barY - 7, "LoaderBar").setOrigin(0, 0.5);
        this.loaderBar.setDepth(5);
        var loadingText = scene.add.text(this.loaderBar.x + 20, this.loaderBar.y - 24, "0%", {
            fontFamily: "Impact",
            color: "White",
            stroke: "Black",
            strokeThickness: 1,
            fontSize: "38px"
        });
        loadingText.setOrigin(0);
        loadingText.setShadow(0, 4, "rgba(0,0,0,0.25)", 5);
        loadingText.setDepth(6);
        this.loaderGroup.addMultiple([
            this.loaderBarBorder,
            this.loadBg,
            this.loaderBarBG,
            this.loaderBar,
            loadingText
        ]);
        this.loaderGroup.setVisible(false);
        scene.load.on("progress", this.updateBar, {
            loaderBar: this.loaderBar,
            loadingText: loadingText,
            game: scene.game
        });
        scene.load.on("complete", this.complete, {
            scene: scene,
            callback: this.callback,
            loaderGroup: this.loaderGroup
        });
        scene.load.on("load", function(file) {
            if (this.loaderGroup.children != undefined) this.loaderGroup.setVisible(true);
        }, {
            loaderGroup: this.loaderGroup
        });
    },
    updateBar: function(percentage) {
        if (this != undefined && !this.done && this.loadingText.scene != undefined) {
            this.loaderBar.setScale(percentage, 1);
            percentage = percentage * 100;
            if (this.loadingText != null) this.loadingText.setText(percentage.toFixed(0) + "%");
        }
    },
    complete: function() {
        if (this.loaderGroup.scene != undefined) {
            this.loaderGroup.setVisible(false);
            this.callback();
            this.done = true;
        }
    }
};

//# sourceMappingURL=index.d45e3eb1.js.map
