/*

    Main.js
    - configure Phaser, Faye, Webfonts


*/ var width = gameConfig.screenResolution.width;
var height = gameConfig.screenResolution.height;
var centerX = width * 0.5;
var centerY = height * 0.5;
var stageScale = gameConfig.ratio;
var dialogManager, fullDialog, allHints;
var audioContext = new (window.AudioContext || window.webkitAudioContext)();
var disableWebAudioFlag = true;
if (/Android|webOS|iPhone|iPad|iPod|Opera Mini/i.test(navigator.userAgent) || isIOS()) disableWebAudioFlag = false; // web audio must be active in mobile browsers!
var config = {
    type: Phaser.AUTO,
    width: width * stageScale,
    height: height * stageScale,
    scale: {
        mode: Phaser.Scale.FIT,
        autoCenter: Phaser.Scale.CENTER_BOTH,
        width: width * stageScale,
        height: height * stageScale
    },
    physics: {
        default: "matter"
    },
    fps: {
        target: 30,
        forceSetTimeOut: true
    },
    audio: {
        context: audioContext
    },
    callbacks: {
        preBoot: function(game) {
            game.music = Phaser.Sound.SoundManagerCreator.create(game);
            game.sfx = Phaser.Sound.SoundManagerCreator.create(game);
            game.speech = Phaser.Sound.SoundManagerCreator.create(game);
        }
    },
    loader: {
        maxParallelDownloads: 1
    },
    pixelArt: false,
    preserveDrawingBuffer: true,
    backgroundColor: "#000000",
    dom: {
        createContainer: true
    },
    parent: "gameDiv",
    scene: [
        Boot,
        Preloader,
        MainMenu,
        GameOver,
        UILayer,
        Modal,
        Audio,
        DialogManager,
        Gametimer,
        Scene01,
        Credits
    ]
};
var game = new Phaser.Game(config);
var parent = this;
// loading font faces
loadFont("FontBold", "assets/fonts/RobotoMono-Bold.ttf");
loadFont("digital-7", "assets/fonts/digital-7.ttf");
loadFont("TheSansMono-8-Bold", "assets/fonts/TheSansMono-8-XBold.otf");
loadFont("AkzidenzGrotesk-ExtraBold", "assets/fonts/AkzidenzGrotesk-ExtraBoldCond.otf");
WebFont.load({
    custom: {
        families: [
            "Font",
            "FontMedium",
            "FontMediumItalic",
            "FontBold"
        ]
    },
    active: startScenes()
});
function startScenes() {
    game.scene.start("Boot");
}

//# sourceMappingURL=index.e84b1232.js.map
